/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.SignUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocationUtil {
    private LocationUtil() {
    }

    public static void init() {
    }

    public static boolean isWithinRadius(Location l1, Location l2, int radius) {
        return l1.getWorld().equals(l2.getWorld()) && Math.floor(LocationUtil.getDistanceSquared(l1, l2)) <= (double)(radius * radius);
    }

    public static Entity[] getNearbyEntities(Location l, int radius) {
        int chunkRadius = radius < 16 ? 1 : radius / 16;
        HashSet<Entity> radiusEntities = new HashSet<Entity>();
        for (int chX = 0 - chunkRadius; chX <= chunkRadius; ++chX) {
            for (int chZ = 0 - chunkRadius; chZ <= chunkRadius; ++chZ) {
                int x = (int)l.getX();
                int y = (int)l.getY();
                int z = (int)l.getZ();
                for (Entity e : new Location(l.getWorld(), (double)(x + chX * 16), (double)y, (double)(z + chZ * 16)).getChunk().getEntities()) {
                    if (!(e.getLocation().distanceSquared(l) <= (double)(radius * radius)) || e.getLocation().getBlock() == l.getBlock()) continue;
                    radiusEntities.add(e);
                }
            }
        }
        return radiusEntities.toArray(new Entity[radiusEntities.size()]);
    }

    public static double getDistance(Location l1, Location l2) {
        return Math.sqrt(LocationUtil.getDistanceSquared(l1, l2));
    }

    public static double getDistanceSquared(Location l1, Location l2) {
        if (CraftBookPlugin.getInstance().getLocalConfiguration().useBlockDistance) {
            return LocationUtil.getBlockDistance(l1, l2) * LocationUtil.getBlockDistance(l1, l2);
        }
        return l1.distanceSquared(l2);
    }

    public static int getBlockDistance(Location l1, Location l2) {
        int x = Math.abs(l1.getBlockX() - l2.getBlockX());
        int y = Math.abs(l1.getBlockY() - l2.getBlockY());
        int z = Math.abs(l1.getBlockZ() - l2.getBlockZ());
        if (x >= y && x >= z) {
            return x;
        }
        if (y >= z) {
            return y;
        }
        return z;
    }

    public static Block getOffset(Block block, int offsetX, int offsetY, int offsetZ) {
        return block.getWorld().getBlockAt(block.getX() + offsetX, block.getY() + offsetY, block.getZ() + offsetZ);
    }

    public static Block getRelativeOffset(ChangedSign sign, int offsetX, int offsetY, int offsetZ) {
        return LocationUtil.getRelativeOffset(SignUtil.getBackBlock(BukkitUtil.toSign(sign).getBlock()), SignUtil.getFacing(BukkitUtil.toSign(sign).getBlock()), offsetX, offsetY, offsetZ);
    }

    public static Block getRelativeOffset(Block block, BlockFace facing, int offsetX, int offsetY, int offsetZ) {
        BlockFace right;
        BlockFace left;
        BlockFace back;
        BlockFace front = facing;
        switch (front) {
            case SOUTH: {
                back = BlockFace.NORTH;
                left = BlockFace.EAST;
                right = BlockFace.WEST;
                break;
            }
            case WEST: {
                back = BlockFace.EAST;
                left = BlockFace.SOUTH;
                right = BlockFace.NORTH;
                break;
            }
            case NORTH: {
                back = BlockFace.SOUTH;
                left = BlockFace.WEST;
                right = BlockFace.EAST;
                break;
            }
            case EAST: {
                back = BlockFace.WEST;
                left = BlockFace.NORTH;
                right = BlockFace.SOUTH;
                break;
            }
            default: {
                back = BlockFace.SOUTH;
                left = BlockFace.EAST;
                right = BlockFace.WEST;
            }
        }
        if (offsetX > 0) {
            block = LocationUtil.getRelativeBlock(block, right, offsetX);
        } else if (offsetX < 0) {
            block = LocationUtil.getRelativeBlock(block, left, offsetX);
        }
        if (offsetZ > 0) {
            block = LocationUtil.getRelativeBlock(block, front, offsetZ);
        } else if (offsetZ < 0) {
            block = LocationUtil.getRelativeBlock(block, back, offsetZ);
        }
        if (offsetY > 0) {
            block = LocationUtil.getRelativeBlock(block, BlockFace.UP, offsetY);
        } else if (offsetY < 0) {
            block = LocationUtil.getRelativeBlock(block, BlockFace.DOWN, offsetY);
        }
        return block;
    }

    public static Set<Chunk> getSurroundingChunks(Block block, int radius) {
        Chunk chunk = block.getChunk();
        radius = radius / 16 + 1;
        LinkedHashSet<Chunk> chunks = new LinkedHashSet<Chunk>();
        World world = chunk.getWorld();
        int cX = chunk.getX();
        int cZ = chunk.getZ();
        for (int x = radius; x >= 0; --x) {
            for (int z = radius; z >= 0; --z) {
                chunks.add(world.getChunkAt(cX + x, cZ + z));
                chunks.add(world.getChunkAt(cX - x, cZ - z));
                chunks.add(world.getChunkAt(cX + x, cZ - z));
                chunks.add(world.getChunkAt(cX - x, cZ + z));
                chunks.add(world.getChunkAt(cX + x, cZ));
                chunks.add(world.getChunkAt(cX - x, cZ));
                chunks.add(world.getChunkAt(cX, cZ + z));
                chunks.add(world.getChunkAt(cX, cZ - z));
            }
        }
        return chunks;
    }

    private static Block getRelativeBlock(Block block, BlockFace facing, int amount) {
        amount = Math.abs(amount);
        for (int i = 0; i < amount; ++i) {
            block = block.getRelative(facing);
        }
        return block;
    }

    public static Block getNextFreeSpace(Block block, BlockFace direction) {
        while (block.getTypeId() != 0 && block.getRelative(direction).getTypeId() != 0 && block.getY() < block.getWorld().getMaxHeight()) {
            block = block.getRelative(direction);
        }
        return block;
    }

    public static Location getCenterOfBlock(Block block) {
        return block.getLocation().add(0.5, 1.0, 0.5);
    }

    public static List<Player> getNearbyPlayers(Block block, int radius) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Chunk chunk : LocationUtil.getSurroundingChunks(block, radius)) {
            for (Entity e : chunk.getEntities()) {
                if (!(e instanceof Player)) continue;
                players.add((Player)e);
            }
        }
        return players;
    }
}

