/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util;

import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;

public class SignUtil {
    private SignUtil() {
    }

    public static boolean isSign(Block keith) {
        return SignUtil.isSign(keith.getTypeId());
    }

    public static boolean isSign(int typeid) {
        return typeid == 63 || typeid == 68;
    }

    public static BlockFace getFacing(Block sign) {
        return SignUtil.getBack(sign);
    }

    public static BlockFace getFront(Block sign) {
        if (BaseBukkitPlugin.useOldBlockFace()) {
            if (sign.getTypeId() == 63) {
                switch (sign.getData()) {
                    case 0: {
                        return BlockFace.WEST;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        return BlockFace.NORTH_WEST;
                    }
                    case 4: {
                        return BlockFace.NORTH;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        return BlockFace.NORTH_EAST;
                    }
                    case 8: {
                        return BlockFace.EAST;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        return BlockFace.SOUTH_EAST;
                    }
                    case 12: {
                        return BlockFace.SOUTH;
                    }
                    case 13: 
                    case 14: 
                    case 15: {
                        return BlockFace.SOUTH_WEST;
                    }
                }
                return BlockFace.SELF;
            }
            switch (sign.getData()) {
                case 3: {
                    return BlockFace.WEST;
                }
                case 2: {
                    return BlockFace.EAST;
                }
                case 4: {
                    return BlockFace.NORTH;
                }
                case 5: {
                    return BlockFace.SOUTH;
                }
            }
            return BlockFace.SELF;
        }
        if (sign.getTypeId() == 63) {
            switch (sign.getData()) {
                case 0: {
                    return BlockFace.SOUTH;
                }
                case 1: 
                case 2: 
                case 3: {
                    return BlockFace.SOUTH_WEST;
                }
                case 4: {
                    return BlockFace.WEST;
                }
                case 5: 
                case 6: 
                case 7: {
                    return BlockFace.NORTH_WEST;
                }
                case 8: {
                    return BlockFace.NORTH;
                }
                case 9: 
                case 10: 
                case 11: {
                    return BlockFace.NORTH_EAST;
                }
                case 12: {
                    return BlockFace.EAST;
                }
                case 13: 
                case 14: 
                case 15: {
                    return BlockFace.SOUTH_EAST;
                }
            }
            return BlockFace.SELF;
        }
        switch (sign.getData()) {
            case 2: {
                return BlockFace.NORTH;
            }
            case 3: {
                return BlockFace.SOUTH;
            }
            case 4: {
                return BlockFace.WEST;
            }
            case 5: {
                return BlockFace.EAST;
            }
        }
        return BlockFace.SELF;
    }

    public static Block getFrontBlock(Block sign) {
        return sign.getRelative(SignUtil.getFront(sign));
    }

    public static BlockFace getBack(Block sign) {
        if (BaseBukkitPlugin.useOldBlockFace()) {
            if (sign.getTypeId() == 63) {
                switch (sign.getData()) {
                    case 0: {
                        return BlockFace.EAST;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        return BlockFace.SOUTH_EAST;
                    }
                    case 4: {
                        return BlockFace.SOUTH;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        return BlockFace.SOUTH_WEST;
                    }
                    case 8: {
                        return BlockFace.WEST;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        return BlockFace.NORTH_WEST;
                    }
                    case 12: {
                        return BlockFace.NORTH;
                    }
                    case 13: 
                    case 14: 
                    case 15: {
                        return BlockFace.NORTH_EAST;
                    }
                }
                return BlockFace.SELF;
            }
            switch (sign.getData()) {
                case 3: {
                    return BlockFace.EAST;
                }
                case 2: {
                    return BlockFace.WEST;
                }
                case 4: {
                    return BlockFace.SOUTH;
                }
                case 5: {
                    return BlockFace.NORTH;
                }
            }
            return BlockFace.SELF;
        }
        if (sign.getTypeId() == 63) {
            switch (sign.getData()) {
                case 0: {
                    return BlockFace.NORTH;
                }
                case 1: 
                case 2: 
                case 3: {
                    return BlockFace.NORTH_EAST;
                }
                case 4: {
                    return BlockFace.EAST;
                }
                case 5: 
                case 6: 
                case 7: {
                    return BlockFace.SOUTH_EAST;
                }
                case 8: {
                    return BlockFace.SOUTH;
                }
                case 9: 
                case 10: 
                case 11: {
                    return BlockFace.SOUTH_WEST;
                }
                case 12: {
                    return BlockFace.WEST;
                }
                case 13: 
                case 14: 
                case 15: {
                    return BlockFace.NORTH_WEST;
                }
            }
            return BlockFace.SELF;
        }
        switch (sign.getData()) {
            case 2: {
                return BlockFace.SOUTH;
            }
            case 3: {
                return BlockFace.NORTH;
            }
            case 4: {
                return BlockFace.EAST;
            }
            case 5: {
                return BlockFace.WEST;
            }
        }
        return BlockFace.SELF;
    }

    public static Block getBackBlock(Block sign) {
        return sign.getRelative(SignUtil.getBack(sign));
    }

    public static Sign getNextSign(Sign sign, String criterea, int searchRadius) {
        Sign otherSign = sign;
        Block otherBlock = otherSign.getBlock();
        BlockFace way = sign.getBlock().getFace(SignUtil.getBackBlock(sign.getBlock()));
        for (int i = 0; !(i >= searchRadius || otherBlock.getRelative(way).getState() instanceof Sign && (otherSign = (Sign)otherBlock.getRelative(way).getState()).getLine(1).equalsIgnoreCase(criterea)); ++i) {
            otherBlock = otherBlock.getRelative(way);
        }
        if (otherSign.equals(sign)) {
            return null;
        }
        return otherSign;
    }

    public static BlockFace getRight(Block sign) {
        if (BaseBukkitPlugin.useOldBlockFace()) {
            if (sign.getTypeId() == 63) {
                switch (sign.getData()) {
                    case 0: {
                        return BlockFace.SOUTH;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        return BlockFace.SOUTH_WEST;
                    }
                    case 4: {
                        return BlockFace.WEST;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        return BlockFace.NORTH_WEST;
                    }
                    case 8: {
                        return BlockFace.NORTH;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        return BlockFace.NORTH_EAST;
                    }
                    case 12: {
                        return BlockFace.EAST;
                    }
                    case 13: 
                    case 14: 
                    case 15: {
                        return BlockFace.SOUTH_EAST;
                    }
                }
                return BlockFace.SELF;
            }
            switch (sign.getData()) {
                case 3: {
                    return BlockFace.SOUTH;
                }
                case 2: {
                    return BlockFace.NORTH;
                }
                case 4: {
                    return BlockFace.WEST;
                }
                case 5: {
                    return BlockFace.EAST;
                }
            }
            return BlockFace.SELF;
        }
        if (sign.getTypeId() == 63) {
            switch (sign.getData()) {
                case 0: {
                    return BlockFace.EAST;
                }
                case 1: 
                case 2: 
                case 3: {
                    return BlockFace.SOUTH_EAST;
                }
                case 4: {
                    return BlockFace.SOUTH;
                }
                case 5: 
                case 6: 
                case 7: {
                    return BlockFace.SOUTH_WEST;
                }
                case 8: {
                    return BlockFace.WEST;
                }
                case 9: 
                case 10: 
                case 11: {
                    return BlockFace.NORTH_WEST;
                }
                case 12: {
                    return BlockFace.NORTH;
                }
                case 13: 
                case 14: 
                case 15: {
                    return BlockFace.NORTH_EAST;
                }
            }
            return BlockFace.SELF;
        }
        switch (sign.getData()) {
            case 2: {
                return BlockFace.WEST;
            }
            case 3: {
                return BlockFace.EAST;
            }
            case 4: {
                return BlockFace.SOUTH;
            }
            case 5: {
                return BlockFace.NORTH;
            }
        }
        return BlockFace.SELF;
    }

    public static Block getLeftBlock(Block sign) {
        return sign.getRelative(SignUtil.getLeft(sign));
    }

    public static BlockFace getLeft(Block sign) {
        if (BaseBukkitPlugin.useOldBlockFace()) {
            if (sign.getTypeId() == 63) {
                switch (sign.getData()) {
                    case 0: {
                        return BlockFace.NORTH;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        return BlockFace.NORTH_EAST;
                    }
                    case 4: {
                        return BlockFace.EAST;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        return BlockFace.SOUTH_EAST;
                    }
                    case 8: {
                        return BlockFace.SOUTH;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        return BlockFace.SOUTH_WEST;
                    }
                    case 12: {
                        return BlockFace.WEST;
                    }
                    case 13: 
                    case 14: 
                    case 15: {
                        return BlockFace.NORTH_WEST;
                    }
                }
                return BlockFace.SELF;
            }
            switch (sign.getData()) {
                case 3: {
                    return BlockFace.NORTH;
                }
                case 2: {
                    return BlockFace.SOUTH;
                }
                case 4: {
                    return BlockFace.EAST;
                }
                case 5: {
                    return BlockFace.WEST;
                }
            }
            return BlockFace.SELF;
        }
        if (sign.getTypeId() == 63) {
            switch (sign.getData()) {
                case 0: {
                    return BlockFace.WEST;
                }
                case 1: 
                case 2: 
                case 3: {
                    return BlockFace.NORTH_WEST;
                }
                case 4: {
                    return BlockFace.NORTH;
                }
                case 5: 
                case 6: 
                case 7: {
                    return BlockFace.NORTH_EAST;
                }
                case 8: {
                    return BlockFace.EAST;
                }
                case 9: 
                case 10: 
                case 11: {
                    return BlockFace.SOUTH_EAST;
                }
                case 12: {
                    return BlockFace.SOUTH;
                }
                case 13: 
                case 14: 
                case 15: {
                    return BlockFace.SOUTH_WEST;
                }
            }
            return BlockFace.SELF;
        }
        switch (sign.getData()) {
            case 2: {
                return BlockFace.EAST;
            }
            case 3: {
                return BlockFace.WEST;
            }
            case 4: {
                return BlockFace.NORTH;
            }
            case 5: {
                return BlockFace.SOUTH;
            }
        }
        return BlockFace.SELF;
    }

    public static Block getRightBlock(Block sign) {
        return sign.getRelative(SignUtil.getRight(sign));
    }

    public static boolean isCardinal(Block sign) {
        if (sign.getTypeId() == 63) {
            switch (sign.getData()) {
                case 0: 
                case 4: 
                case 8: 
                case 12: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static BlockFace getClockWise(BlockFace face) {
        switch (face) {
            case NORTH: {
                return BlockFace.EAST;
            }
            case EAST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.NORTH;
            }
        }
        return BlockFace.SELF;
    }

    public static BlockFace getCounterClockWise(BlockFace face) {
        switch (face) {
            case NORTH: {
                return BlockFace.WEST;
            }
            case EAST: {
                return BlockFace.NORTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
        }
        return BlockFace.SELF;
    }

    public static void setLine(Sign sign, int line, String content) {
        sign.setLine(line, content);
        sign.update();
    }
}

