/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook;

import com.sk89q.craftbook.BaseConfiguration;
import com.sk89q.craftbook.mech.CustomDropManager;
import java.io.File;
import java.util.Arrays;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;

public class MechanismsConfiguration
extends BaseConfiguration {
    public MechanismSettings mechSettings;
    public AmmeterSettings ammeterSettings;
    public BookcaseSettings bookcaseSettings;
    public BridgeSettings bridgeSettings;
    public DoorSettings doorSettings;
    public GateSettings gateSettings;
    public ElementalArrowsSettings elementalArrowSettings;
    public ElevatorSettings elevatorSettings;
    public TeleporterSettings teleporterSettings;
    public CauldronSettings cauldronSettings;
    public LightStoneSettings lightStoneSettings;
    public LightSwitchSettings lightSwitchSettings;
    public HiddenSwitchSettings hiddenSwitchSettings;
    public SnowSettings snowSettings;
    public AreaSettings areaSettings;
    public CommandSettings commandSettings;
    public CustomDropManager customDrops;
    public CustomDropSettings customDropSettings;
    public DispenserSettings dispenserSettings;
    public ChairSettings chairSettings;
    public AISettings aiSettings;
    public AnchorSettings anchorSettings;
    public CookingPotSettings cookingPotSettings;
    public CustomCraftingSettings customCraftingSettings;
    public PaintingSettings paintingSettings;
    public PaymentSettings paymentSettings;
    public XPStorerSettings xpStorerSettings;
    public MapChangerSettings mapChangerSettings;

    public MechanismsConfiguration(FileConfiguration cfg, File dataFolder) {
        super(cfg, dataFolder);
    }

    public void load() {
        this.aiSettings = new AISettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "AI Mechanics"));
        this.ammeterSettings = new AmmeterSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Ammeter"));
        this.anchorSettings = new AnchorSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Chunk Anchor"));
        this.areaSettings = new AreaSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Toggle Areas"));
        this.bookcaseSettings = new BookcaseSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Bookcase"));
        this.bridgeSettings = new BridgeSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Bridge"));
        this.cauldronSettings = new CauldronSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Cauldron"));
        this.chairSettings = new ChairSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Chairs"));
        this.commandSettings = new CommandSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Command Sign"));
        this.cookingPotSettings = new CookingPotSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Cooking Pot"));
        this.customCraftingSettings = new CustomCraftingSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Custom Crafting"));
        this.customDropSettings = new CustomDropSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Custom Drops"));
        this.dispenserSettings = new DispenserSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Dispenser Recipes"));
        this.doorSettings = new DoorSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Door"));
        this.elevatorSettings = new ElevatorSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Elevator"));
        this.gateSettings = new GateSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Gate"));
        this.hiddenSwitchSettings = new HiddenSwitchSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Hidden Switch"));
        this.lightStoneSettings = new LightStoneSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Lightstone"));
        this.lightSwitchSettings = new LightSwitchSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Light Switch"));
        this.mapChangerSettings = new MapChangerSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Map Changer"));
        this.paintingSettings = new PaintingSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Painting Settings"));
        this.paymentSettings = new PaymentSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Payment Settings"));
        this.snowSettings = new SnowSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Snow"));
        this.teleporterSettings = new TeleporterSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Teleporter"));
        this.xpStorerSettings = new XPStorerSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "XP Storer"));
        this.mechSettings = new MechanismSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Mechanisms"));
        this.customDrops = new CustomDropManager(this.dataFolder);
    }

    public class MechanismSettings {
        public final boolean stopDestruction;

        private MechanismSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.stopDestruction = section.getBoolean("stop-mechanism-dupe", true);
        }
    }

    public class XPStorerSettings {
        public final boolean enabled;
        public final int material;

        private XPStorerSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enabled = section.getBoolean("enable", true);
            this.material = section.getInt("block", 52);
        }
    }

    public class TeleporterSettings {
        public final boolean enable;
        public final int maxrange;
        public final boolean requiresign;

        private TeleporterSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
            this.maxrange = section.getInt("max-range", -1);
            this.requiresign = section.getBoolean("need-sign-destination", false);
        }
    }

    public class SnowSettings {
        public final boolean enable;
        public final boolean trample;
        public final boolean placeSnow;
        public final boolean jumpTrample;
        public final boolean piling;
        public final boolean realistic;

        private SnowSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("piling-enable", true);
            this.trample = section.getBoolean("trample-enable", true);
            this.placeSnow = section.getBoolean("placable-snow", true);
            this.jumpTrample = section.getBoolean("jump-trample-only", true);
            this.piling = section.getBoolean("pile-high", false);
            this.realistic = section.getBoolean("realistic-piling", false);
        }
    }

    public class PaymentSettings {
        public final boolean enabled;

        private PaymentSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enabled = section.getBoolean("enable", true);
        }
    }

    public class PaintingSettings {
        public final boolean enabled;

        private PaintingSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enabled = section.getBoolean("enable", true);
        }
    }

    public class MapChangerSettings {
        public final boolean enabled;

        private MapChangerSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enabled = section.getBoolean("enable", true);
        }
    }

    public class LightSwitchSettings {
        public final boolean enable;
        public final int maxRange;
        public final int maxMaximum;

        private LightSwitchSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
            this.maxRange = section.getInt("max-range", 10);
            this.maxMaximum = section.getInt("max-lights", 20);
        }
    }

    public class LightStoneSettings {
        public final boolean enable;
        public final int id;

        private LightStoneSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
            this.id = section.getInt("item-id", 348);
        }
    }

    public class HiddenSwitchSettings {
        public final boolean enable;
        public final boolean anyside;

        private HiddenSwitchSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
            this.anyside = section.getBoolean("any-side", true);
        }
    }

    public class GateSettings {
        public final boolean enable;
        public final boolean enableRedstone;
        public final boolean limitColumns;
        public final int maxColumns;
        public final Set<Integer> allowedBlocks;

        private GateSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
            this.enableRedstone = section.getBoolean("redstone", true);
            this.limitColumns = section.getBoolean("limit-columns", true);
            this.maxColumns = section.getInt("max-columns", 14);
            this.allowedBlocks = section.getIntegerSet("blocks", Arrays.asList(85, 101, 102, 113));
        }

        public boolean canUseBlock(int b) {
            return this.allowedBlocks.contains(b);
        }
    }

    public class ElevatorSettings {
        public final boolean enable;
        public final boolean loop;
        public final boolean buttons;

        private ElevatorSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
            this.loop = section.getBoolean("loop-top-bottom", false);
            this.buttons = section.getBoolean("allow-button-on-back", true);
        }
    }

    public class ElementalArrowsSettings {
        public final boolean enable;

        private ElementalArrowsSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
        }
    }

    public class DoorSettings {
        public final boolean enable;
        public final boolean enableRedstone;
        public final int maxLength;
        public final int maxWidth;
        public final Set<Integer> allowedBlocks;

        private DoorSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
            this.enableRedstone = section.getBoolean("redstone", true);
            this.maxLength = section.getInt("max-length", 30);
            this.maxWidth = section.getInt("max-width", 5);
            this.allowedBlocks = section.getIntegerSet("blocks", Arrays.asList(4, 5, 20, 43));
        }

        public boolean canUseBlock(int b) {
            return this.allowedBlocks.contains(b);
        }
    }

    public class DispenserSettings {
        public final boolean enable;

        private DispenserSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
        }
    }

    public class CustomDropSettings {
        public final boolean enable;
        public final boolean requirePermissions;

        private CustomDropSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
            this.requirePermissions = section.getBoolean("require-permissions", false);
        }
    }

    public class CustomCraftingSettings {
        public final boolean enable;

        private CustomCraftingSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
        }
    }

    public class CookingPotSettings {
        public final boolean enable;
        public final boolean requiresfuel;
        public final boolean cooksOres;
        public final boolean openClick;

        private CookingPotSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
            this.requiresfuel = section.getBoolean("requires-fuel", false);
            this.cooksOres = section.getBoolean("cooks-everything", false);
            this.openClick = section.getBoolean("open-on-click", false);
        }
    }

    public class CommandSettings {
        public final boolean enable;

        private CommandSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
        }
    }

    public class ChairSettings {
        public final boolean healthRegen;
        public final boolean enable;
        public final boolean requireSneak;
        public final Set<Integer> allowedBlocks;

        private ChairSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
            this.requireSneak = section.getBoolean("sneaking", true);
            this.healthRegen = section.getBoolean("health-regen", true);
            this.allowedBlocks = section.getIntegerSet("blocks", Arrays.asList(53, 67, 108, 109, 114, 128, 134, 135, 136));
        }

        public boolean canUseBlock(Integer b) {
            return this.allowedBlocks.contains(b);
        }
    }

    public class CauldronSettings {
        public final boolean enable;
        public final int cauldronBlock;
        public final boolean enableNew;
        public final boolean newSpoons;

        private CauldronSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("legacy-enable", false);
            this.cauldronBlock = section.getInt("legacy-block", 1);
            this.enableNew = section.getBoolean("new-enable", true);
            this.newSpoons = section.getBoolean("new-spoons", true);
        }
    }

    public class BridgeSettings {
        public final boolean enable;
        public final boolean enableRedstone;
        public final int maxLength;
        public final int maxWidth;
        public final Set<Integer> allowedBlocks;

        private BridgeSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
            this.enableRedstone = section.getBoolean("redstone", true);
            this.maxLength = section.getInt("max-length", 30);
            this.maxWidth = section.getInt("max-width", 5);
            this.allowedBlocks = section.getIntegerSet("blocks", Arrays.asList(4, 5, 20, 43));
        }

        public boolean canUseBlock(Integer b) {
            return this.allowedBlocks.contains(b);
        }
    }

    public class BookcaseSettings {
        public final boolean enable;
        public final String readLine;

        private BookcaseSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
            this.readLine = section.getString("read-text", "You pick up a book...");
        }
    }

    public class AreaSettings {
        public final boolean enable;
        public final boolean enableRedstone;
        public final int maxAreasPerUser;
        public final int maxSizePerArea;
        public final boolean useSchematics;

        private AreaSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
            this.enableRedstone = section.getBoolean("redstone", true);
            this.maxAreasPerUser = section.getInt("max-areas-per-user", 30);
            this.maxSizePerArea = section.getInt("max-size-per-area", 5000);
            this.useSchematics = section.getBoolean("use-schematic", true);
        }
    }

    public class AnchorSettings {
        public final boolean enable;

        private AnchorSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
        }
    }

    public class AmmeterSettings {
        public final boolean enable;
        public final int id;

        private AmmeterSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enable = section.getBoolean("enable", true);
            this.id = section.getInt("item-id", 263);
        }
    }

    public class AISettings {
        public final boolean enabled;
        public final boolean zombieVision;
        public final boolean skeletonCriticals;

        private AISettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enabled = section.getBoolean("enable", true);
            this.zombieVision = section.getBoolean("realistic-zombie-vision", true);
            this.skeletonCriticals = section.getBoolean("skeleton-critical-shot", true);
        }
    }
}

