/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.Tuple2;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CauldronCookbook {
    private static final Pattern AT_PATTERN = Pattern.compile("@", 16);
    private static final Pattern ANYTHING_MULTIPLIED_BY_NUMBER_PATTERN = Pattern.compile("^.*\\*([0-9]+)$");
    private final List<Recipe> recipes = new ArrayList<Recipe>();
    static final Logger log = Logger.getLogger("Minecraft");

    public CauldronCookbook() {
        try {
            CauldronCookbook recipes = this.readCauldronRecipes("cauldron-recipes.txt");
            if (recipes.size() != 0) {
                log.info(recipes.size() + " cauldron recipe(s) loaded");
            } else {
                log.warning("cauldron-recipes.txt had no recipes");
            }
        }
        catch (FileNotFoundException e) {
            log.info("cauldron-recipes.txt not found: " + e.getMessage());
            try {
                log.info("Looked in: " + new File(".").getCanonicalPath() + "/plugins/CraftBookMechanisms");
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            log.warning("cauldron-recipes.txt not loaded: " + e.getMessage());
        }
    }

    public void add(Recipe recipe) {
        this.recipes.add(recipe);
    }

    public Recipe find(Map<Tuple2<Integer, Short>, Integer> ingredients) {
        for (Recipe recipe : this.recipes) {
            if (!recipe.hasAllIngredients(ingredients)) continue;
            return recipe;
        }
        return null;
    }

    public int size() {
        return this.recipes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CauldronCookbook readCauldronRecipes(String path) throws IOException {
        File file = new File("plugins/CraftBookMechanisms", path);
        FileReader input = null;
        try {
            String line;
            input = new FileReader(file);
            BufferedReader buff = new BufferedReader(input);
            while ((line = buff.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.charAt(0) == ';' || line.charAt(0) == '#' || line.isEmpty()) continue;
                String[] parts = RegexUtil.COLON_PATTERN.split(line);
                if (parts.length < 3) {
                    log.log(Level.WARNING, "Invalid cauldron recipe line in " + file.getName() + ": '" + line + "'");
                    continue;
                }
                String name = parts[0];
                List<Tuple2<Integer, Short>> ingredients = this.parseCauldronItems(parts[1]);
                List<Tuple2<Integer, Short>> results = this.parseCauldronItems(parts[2]);
                String[] groups = null;
                if (parts.length >= 4 && !parts[3].trim().isEmpty()) {
                    groups = RegexUtil.COMMA_PATTERN.split(parts[3]);
                }
                Recipe recipe = new Recipe(name, ingredients, results, groups);
                this.add(recipe);
            }
            CauldronCookbook cauldronCookbook = this;
            return cauldronCookbook;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    private List<Tuple2<Integer, Short>> parseCauldronItems(String list) {
        String[] parts = RegexUtil.COMMA_PATTERN.split(list);
        ArrayList<Tuple2<Integer, Short>> out = new ArrayList<Tuple2<Integer, Short>>();
        for (String part : parts) {
            int multiplier = 1;
            try {
                if (ANYTHING_MULTIPLIED_BY_NUMBER_PATTERN.matcher(part).matches()) {
                    int at = part.lastIndexOf(42);
                    multiplier = Integer.parseInt(part.substring(at + 1, part.length()));
                    part = part.substring(0, at);
                }
                try {
                    Short s = 0;
                    String[] split = AT_PATTERN.split(part);
                    Integer id = Integer.valueOf(split[0]);
                    if (split.length > 1) {
                        s = Short.valueOf(split[1]);
                    }
                    for (int i = 0; i < multiplier; ++i) {
                        out.add((Tuple2<Integer, Short>)new Tuple2((Object)id, (Object)s));
                    }
                }
                catch (NumberFormatException e) {
                    log.log(Level.WARNING, "Cauldron: Unknown item " + part);
                }
            }
            catch (NumberFormatException e) {
                log.log(Level.WARNING, "Cauldron: Bad multiplier in '" + part + "'");
            }
        }
        return out;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Recipe {
        private final String name;
        private final List<Tuple2<Integer, Short>> ingredients;
        private final Map<Tuple2<Integer, Short>, Integer> ingredientLookup = new HashMap<Tuple2<Integer, Short>, Integer>();
        private final List<Tuple2<Integer, Short>> results;
        private final String[] groups;

        public Recipe(String name, List<Tuple2<Integer, Short>> ingredients, List<Tuple2<Integer, Short>> results, String[] groups) {
            this.name = name;
            this.ingredients = Collections.unmodifiableList(ingredients);
            this.results = Collections.unmodifiableList(results);
            this.groups = groups;
            for (Tuple2<Integer, Short> id : ingredients) {
                if (this.ingredientLookup.containsKey(id)) {
                    this.ingredientLookup.put(id, this.ingredientLookup.get(id) + 1);
                    continue;
                }
                this.ingredientLookup.put(id, 1);
            }
        }

        public String getName() {
            return this.name;
        }

        public List<Tuple2<Integer, Short>> getIngredients() {
            return this.ingredients;
        }

        public String[] getGroups() {
            return this.groups;
        }

        public boolean hasAllIngredients(Map<Tuple2<Integer, Short>, Integer> check) {
            for (Map.Entry<Tuple2<Integer, Short>, Integer> entry : this.ingredientLookup.entrySet()) {
                Tuple2<Integer, Short> id = entry.getKey();
                if (!check.containsKey(id)) {
                    return false;
                }
                if (check.get(id) >= entry.getValue()) continue;
                return false;
            }
            return true;
        }

        public List<Tuple2<Integer, Short>> getResults() {
            return this.results;
        }
    }
}

