/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.MechanismsConfiguration;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.bukkit.BukkitPlayer;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.regions.CuboidRegion;
import org.bukkit.GameMode;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class Door
extends AbstractMechanic {
    private MechanismsPlugin plugin;
    private MechanismsConfiguration.DoorSettings settings;
    private Block trigger;
    private Block proximalBaseCenter;
    private Block otherSide;
    private CuboidRegion toggle;

    private Door(Block trigger, MechanismsPlugin plugin) throws InvalidMechanismException {
        int i;
        int right;
        int left;
        String otherSignText;
        if (!SignUtil.isCardinal((Block)trigger)) {
            throw new InvalidDirectionException();
        }
        this.trigger = trigger;
        this.plugin = plugin;
        this.settings = plugin.getLocalConfiguration().doorSettings;
        if (trigger == null) {
            return;
        }
        Sign s = (Sign)trigger.getState();
        if (s.getLine(1).equalsIgnoreCase("[Door Up]")) {
            this.proximalBaseCenter = trigger.getRelative(BlockFace.UP);
        } else if (s.getLine(1).equalsIgnoreCase("[Door Down]")) {
            this.proximalBaseCenter = trigger.getRelative(BlockFace.DOWN);
        } else {
            throw new InvalidConstructionException("Sign is incorrectly made.");
        }
        int block = this.proximalBaseCenter.getTypeId();
        if (this.settings.canUseBlock(block)) {
            if (this.proximalBaseCenter.getRelative(SignUtil.getLeft((Block)trigger)).getTypeId() != block || this.proximalBaseCenter.getRelative(SignUtil.getRight((Block)trigger)).getTypeId() != block) {
                throw new InvalidConstructionException("mech.door.material");
            }
        } else {
            throw new UnacceptableMaterialException("mech.door.unusable");
        }
        if (((Sign)trigger.getState()).getLine(1).equalsIgnoreCase("[Door Up]")) {
            this.otherSide = trigger.getRelative(BlockFace.UP);
        } else if (((Sign)trigger.getState()).getLine(1).equalsIgnoreCase("[Door Down]")) {
            this.otherSide = trigger.getRelative(BlockFace.DOWN);
        }
        for (int i2 = 0; !(i2 > this.settings.maxLength || this.otherSide.getTypeId() == 63 && ("[Door Down]".equalsIgnoreCase(otherSignText = ((Sign)this.otherSide.getState()).getLines()[1]) || "[Door Up]".equalsIgnoreCase(otherSignText) || "[Door]".equalsIgnoreCase(otherSignText))); ++i2) {
            if (((Sign)trigger.getState()).getLine(1).equalsIgnoreCase("[Door Up]")) {
                this.otherSide = this.otherSide.getRelative(BlockFace.UP);
                continue;
            }
            if (!((Sign)trigger.getState()).getLine(1).equalsIgnoreCase("[Door Down]")) continue;
            this.otherSide = this.otherSide.getRelative(BlockFace.DOWN);
        }
        if (this.otherSide.getTypeId() != 63) {
            throw new InvalidConstructionException("mech.door.other-sign");
        }
        Block distalBaseCenter = null;
        if (((Sign)trigger.getState()).getLine(1).equalsIgnoreCase("[Door Up]")) {
            distalBaseCenter = this.otherSide.getRelative(BlockFace.DOWN);
        } else if (((Sign)trigger.getState()).getLine(1).equalsIgnoreCase("[Door Down]")) {
            distalBaseCenter = this.otherSide.getRelative(BlockFace.UP);
        }
        if (distalBaseCenter.getTypeId() != block && distalBaseCenter.getData() != this.proximalBaseCenter.getData() || distalBaseCenter.getRelative(SignUtil.getLeft((Block)trigger)).getTypeId() != block && distalBaseCenter.getRelative(SignUtil.getLeft((Block)trigger)).getData() != this.proximalBaseCenter.getData() || distalBaseCenter.getRelative(SignUtil.getRight((Block)trigger)).getTypeId() != block && distalBaseCenter.getRelative(SignUtil.getRight((Block)trigger)).getData() != this.proximalBaseCenter.getData()) {
            throw new InvalidConstructionException("mech.door.material");
        }
        this.toggle = new CuboidRegion((Vector)BukkitUtil.toVector((Block)this.proximalBaseCenter), (Vector)BukkitUtil.toVector((Block)distalBaseCenter));
        try {
            left = Integer.parseInt(s.getLine(2));
            if (left < 0) {
                left = 0;
            }
        }
        catch (Exception e) {
            left = 1;
        }
        try {
            right = Integer.parseInt(s.getLine(3));
            if (right < 0) {
                right = 0;
            }
        }
        catch (Exception e) {
            right = 1;
        }
        if (left > this.settings.maxWidth) {
            left = this.settings.maxWidth;
        }
        if (right > this.settings.maxWidth) {
            right = this.settings.maxWidth;
        }
        for (i = 0; i < left; ++i) {
            this.toggle.expand(new Vector[]{BukkitUtil.toVector((BlockFace)SignUtil.getLeft((Block)trigger)), new Vector(0, 0, 0)});
        }
        for (i = 0; i < right; ++i) {
            this.toggle.expand(new Vector[]{BukkitUtil.toVector((BlockFace)SignUtil.getRight((Block)trigger)), new Vector(0, 0, 0)});
        }
        this.toggle.contract(new Vector[]{BukkitUtil.toVector((BlockFace)BlockFace.UP), BukkitUtil.toVector((BlockFace)BlockFace.DOWN)});
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (!this.settings.enable) {
            return;
        }
        if (!BukkitUtil.toWorldVector((Block)event.getClickedBlock()).equals((Object)BukkitUtil.toWorldVector((Block)this.trigger))) {
            return;
        }
        BukkitPlayer player = new BukkitPlayer((BaseBukkitPlugin)this.plugin, event.getPlayer());
        if (!player.hasPermission("craftbook.mech.door.use")) {
            player.printError("mech.use-permission");
            return;
        }
        if (event.getPlayer().getItemInHand() != null && this.getDoorMaterial() == event.getPlayer().getItemInHand().getTypeId()) {
            BlockState state;
            if (!player.hasPermission("craftbook.mech.door.restock")) {
                player.printError("mech.restock-permission");
                return;
            }
            Sign sign = null;
            if ((event.getClickedBlock().getTypeId() == 63 || event.getClickedBlock().getTypeId() == 68) && (state = event.getClickedBlock().getState()) instanceof Sign) {
                sign = (Sign)state;
            }
            if (sign != null) {
                int amount = 1;
                if (event.getPlayer().isSneaking() && event.getPlayer().getItemInHand().getAmount() >= 5) {
                    amount = 5;
                }
                this.addBlocks(sign, amount);
                if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                    if (event.getPlayer().getItemInHand().getAmount() <= amount) {
                        event.getPlayer().setItemInHand(new ItemStack(0, 0));
                    } else {
                        event.getPlayer().getItemInHand().setAmount(event.getPlayer().getItemInHand().getAmount() - amount);
                    }
                }
                player.print("mech.restock");
                event.setCancelled(true);
                return;
            }
        }
        this.flipState((LocalPlayer)player);
        event.setCancelled(true);
        player.print("mech.door.toggle");
    }

    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!this.plugin.getLocalConfiguration().doorSettings.enableRedstone) {
            return;
        }
        if (!BukkitUtil.toWorldVector((Block)event.getBlock()).equals((Object)BukkitUtil.toWorldVector((Block)this.trigger))) {
            return;
        }
        if (event.getNewCurrent() == event.getOldCurrent()) {
            return;
        }
        this.flipState(null);
    }

    private void flipState(LocalPlayer player) {
        Block hinge = ((Sign)this.trigger.getState()).getLine(1).equalsIgnoreCase("[Door Up]") ? this.proximalBaseCenter.getRelative(BlockFace.UP) : this.proximalBaseCenter.getRelative(BlockFace.DOWN);
        if (Door.canPassThrough(hinge.getTypeId())) {
            new ToggleRegionClosed(player).run();
        } else {
            new ToggleRegionOpen().run();
        }
    }

    private int getDoorMaterial() {
        return this.proximalBaseCenter.getTypeId();
    }

    private byte getDoorData() {
        return this.proximalBaseCenter.getData();
    }

    private static boolean canPassThrough(int t) {
        int[] passableBlocks = new int[]{8, 9, 10, 11, 85, 78, 31, 106, 32, 0};
        for (int aPassableBlock : passableBlocks) {
            if (aPassableBlock != t) continue;
            return true;
        }
        return false;
    }

    public void onBlockBreak(BlockBreakEvent event) {
        BlockState state;
        Sign sign = null;
        if (event.getBlock().getTypeId() == 68 && (state = event.getBlock().getState()) instanceof Sign) {
            sign = (Sign)state;
        }
        if (this.hasEnoughBlocks(sign)) {
            ItemStack toDrop = new ItemStack(this.getDoorMaterial(), this.getBlocks(sign), (short)this.getDoorData());
            if (sign != null) {
                sign.getWorld().dropItemNaturally(sign.getLocation(), toDrop);
            }
        }
    }

    public boolean removeBlocks(Sign s, int amount) {
        if (s.getLine(0).equalsIgnoreCase("infinite")) {
            return true;
        }
        int curBlocks = this.getBlocks(s) - amount;
        s.setLine(0, String.valueOf(curBlocks));
        s.update();
        return curBlocks >= 0;
    }

    public boolean addBlocks(Sign s, int amount) {
        if (s.getLine(0).equalsIgnoreCase("infinite")) {
            return true;
        }
        int curBlocks = this.getBlocks(s) + amount;
        s.setLine(0, String.valueOf(curBlocks));
        s.update();
        return curBlocks >= 0;
    }

    public int getBlocks(Sign s) {
        int curBlocks;
        if (s.getLine(0).equalsIgnoreCase("infinite")) {
            return 100000;
        }
        try {
            curBlocks = Integer.parseInt(s.getLine(0));
        }
        catch (NumberFormatException e) {
            curBlocks = 0;
        }
        return curBlocks;
    }

    public boolean hasEnoughBlocks(Sign s) {
        return s != null && s.getLine(0) != null && (s.getLine(0).equalsIgnoreCase("infinite") || this.getBlocks(s) > 0);
    }

    private static class InvalidConstructionException
    extends InvalidMechanismException {
        private static final long serialVersionUID = 4943494589521864491L;

        public InvalidConstructionException(String msg) {
            super(msg);
        }
    }

    private static class UnacceptableMaterialException
    extends InvalidMechanismException {
        private static final long serialVersionUID = 8340723004466483212L;

        public UnacceptableMaterialException(String msg) {
            super(msg);
        }
    }

    private static class InvalidDirectionException
    extends InvalidMechanismException {
        private static final long serialVersionUID = -3183606604247616362L;

        private InvalidDirectionException() {
        }
    }

    private class ToggleRegionClosed
    implements Runnable {
        final LocalPlayer player;

        public ToggleRegionClosed(LocalPlayer player) {
            this.player = player;
        }

        public void run() {
            for (BlockVector bv : Door.this.toggle) {
                Block b = Door.this.trigger.getWorld().getBlockAt(bv.getBlockX(), bv.getBlockY(), bv.getBlockZ());
                if (!Door.canPassThrough(b.getTypeId())) continue;
                if (((Door)Door.this).plugin.getLocalConfiguration().mechSettings.stopDestruction) {
                    Sign s = (Sign)Door.this.trigger.getState();
                    if (Door.this.hasEnoughBlocks(s)) {
                        b.setTypeId(Door.this.getDoorMaterial());
                        b.setData(Door.this.getDoorData());
                        Door.this.removeBlocks(s, 1);
                        continue;
                    }
                    if (this.player != null) {
                        this.player.printError("Not enough blocks for mechanic to function!");
                    }
                    return;
                }
                b.setTypeId(Door.this.getDoorMaterial());
                b.setData(Door.this.getDoorData());
            }
        }
    }

    private class ToggleRegionOpen
    implements Runnable {
        private ToggleRegionOpen() {
        }

        public void run() {
            for (BlockVector bv : Door.this.toggle) {
                Block b = Door.this.trigger.getWorld().getBlockAt(bv.getBlockX(), bv.getBlockY(), bv.getBlockZ());
                int oldType = b.getTypeId();
                if (b.getTypeId() != Door.this.getDoorMaterial() && !Door.canPassThrough(b.getTypeId())) continue;
                b.setTypeId(0);
                if (!((Door)Door.this).plugin.getLocalConfiguration().mechSettings.stopDestruction) continue;
                Sign s = (Sign)Door.this.trigger.getState();
                if (oldType == 0) continue;
                Door.this.addBlocks(s, 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Door> {
        private final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public Door detect(BlockWorldVector pt, LocalPlayer player, ChangedSign sign) throws InvalidMechanismException, ProcessedMechanismException {
            if (sign.getLine(1).equalsIgnoreCase("[Door Down]")) {
                player.checkPermission("craftbook.mech.door");
                sign.setLine(1, "[Door Down]");
                if (sign.getLine(0).equalsIgnoreCase("infinite") && !player.hasPermission("craftbook.mech.door.infinite")) {
                    sign.setLine(0, "0");
                } else if (!sign.getLine(0).equalsIgnoreCase("infinite")) {
                    sign.setLine(0, "0");
                }
                sign.update(false);
                player.print("mech.door.create");
            } else if (sign.getLine(1).equalsIgnoreCase("[Door Up]")) {
                player.checkPermission("craftbook.mech.door");
                sign.setLine(1, "[Door Up]");
                if (sign.getLine(0).equalsIgnoreCase("infinite") && !player.hasPermission("craftbook.mech.door.infinite")) {
                    sign.setLine(0, "0");
                } else if (!sign.getLine(0).equalsIgnoreCase("infinite")) {
                    sign.setLine(0, "0");
                }
                sign.update(false);
                player.print("mech.door.create");
            } else if (sign.getLine(1).equalsIgnoreCase("[Door]")) {
                player.checkPermission("craftbook.mech.door");
                sign.setLine(1, "[Door]");
                if (sign.getLine(0).equalsIgnoreCase("infinite") && !player.hasPermission("craftbook.mech.door.infinite")) {
                    sign.setLine(0, "0");
                } else if (!sign.getLine(0).equalsIgnoreCase("infinite")) {
                    sign.setLine(0, "0");
                }
                sign.update(false);
                player.print("mech.door.create");
            } else {
                return null;
            }
            throw new ProcessedMechanismException();
        }

        public Door detect(BlockWorldVector pt) throws InvalidMechanismException {
            Block block = BukkitUtil.toBlock((BlockWorldVector)pt);
            if (block.getTypeId() != 63) {
                return null;
            }
            if (!((Sign)block.getState()).getLine(1).contains("Door") || ((Sign)block.getState()).getLine(1).equalsIgnoreCase("[Door]")) {
                return null;
            }
            return new Door(block, this.plugin);
        }
    }
}

