/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech.cauldron;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.mech.cauldron.CauldronItemStack;
import com.sk89q.craftbook.mech.cauldron.ImprovedCauldronCookbook;
import com.sk89q.craftbook.mech.cauldron.UnknownRecipeException;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Cauldron;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImprovedCauldron
extends AbstractMechanic
implements Listener {
    private MechanismsPlugin plugin;
    private Block block;
    private ImprovedCauldronCookbook cookbook;

    private ImprovedCauldron(MechanismsPlugin plugin, Block block, ImprovedCauldronCookbook recipes) {
        this.plugin = plugin;
        this.block = block;
        this.cookbook = recipes;
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (!this.plugin.getLocalConfiguration().cauldronSettings.enableNew) {
            return;
        }
        LocalPlayer player = this.plugin.wrap(event.getPlayer());
        if (this.block.equals(event.getClickedBlock())) {
            if (!player.hasPermission("craftbook.mech.cauldron.use")) {
                player.printError("mech.use-permission");
                return;
            }
            try {
                Collection<Item> items = this.getItems();
                ImprovedCauldronCookbook.Recipe recipe = this.cookbook.getRecipe(CauldronItemStack.convert(items));
                if (!player.hasPermission("craftbook.mech.cauldron.recipe.*") && !player.hasPermission("craftbook.mech.cauldron.recipe." + recipe.getId())) {
                    player.printError("You dont have permission to cook this recipe.");
                    return;
                }
                if (!this.plugin.getLocalConfiguration().cauldronSettings.newSpoons) {
                    this.cook(recipe, items);
                    player.print("You have cooked the " + ChatColor.AQUA + recipe.getName() + ChatColor.YELLOW + " " + "recipe.");
                    this.block.getWorld().createExplosion(this.block.getRelative(BlockFace.UP).getLocation(), 0.0f, false);
                    event.setCancelled(true);
                } else {
                    if (event.getPlayer().getItemInHand() == null) {
                        return;
                    }
                    if (this.isItemSpoon(event.getPlayer().getItemInHand().getTypeId())) {
                        double chance = this.getSpoonChance(event.getPlayer().getItemInHand(), recipe.getChance());
                        double ran = BaseBukkitPlugin.random.nextDouble();
                        event.getPlayer().getItemInHand().setDurability((short)(event.getPlayer().getItemInHand().getDurability() - 1));
                        if (chance <= ran) {
                            this.cook(recipe, items);
                            player.print("You have cooked the " + ChatColor.AQUA + recipe.getName() + ChatColor.YELLOW + " recipe.");
                            this.block.getWorld().createExplosion(this.block.getRelative(BlockFace.UP).getLocation(), 0.0f, false);
                            event.setCancelled(true);
                        } else {
                            player.print("mech.cauldron.stir");
                        }
                    }
                }
            }
            catch (UnknownRecipeException e) {
                player.printError(e.getMessage());
            }
        }
    }

    public boolean isItemSpoon(int id) {
        return id == 256 || id == 269 || id == 273 || id == 277 || id == 284;
    }

    public double getSpoonChance(ItemStack item, double chance) {
        int id = item.getTypeId();
        double temp = chance / 100.0;
        if (temp > 1.0) {
            return 1.0;
        }
        double toGo = temp = 1.0 - temp;
        double tenth = toGo / 10.0;
        int mutliplier = 0;
        if (id == 269) {
            mutliplier = 1;
        } else if (id == 273) {
            mutliplier = 2;
        } else if (id == 256) {
            mutliplier = 3;
        } else if (id == 277) {
            mutliplier = 4;
        } else if (id == 284) {
            mutliplier = 5;
        }
        return temp + tenth * (double)(mutliplier += item.getEnchantmentLevel(Enchantment.DIG_SPEED));
    }

    private void cook(ImprovedCauldronCookbook.Recipe recipe, Collection<Item> items) {
        for (Item item : items) {
            item.remove();
        }
        for (CauldronItemStack stack : recipe.getResults()) {
            if (stack.getData() < 0) {
                stack.setData((short)0);
            }
            this.block.getWorld().dropItemNaturally(this.block.getLocation(), stack.getItemStack());
        }
    }

    private Collection<Item> getItems() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Entity entity : this.block.getChunk().getEntities()) {
            Location location;
            if (!(entity instanceof Item) || (location = entity.getLocation()).getBlockX() != this.block.getX() || location.getBlockY() != this.block.getY() || location.getBlockZ() != this.block.getZ()) continue;
            items.add((Item)entity);
        }
        return items;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<ImprovedCauldron> {
        protected final MechanismsPlugin plugin;
        protected final ImprovedCauldronCookbook recipes;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
            this.recipes = new ImprovedCauldronCookbook((FileConfiguration)YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "cauldron-recipes.yml")), plugin.getDataFolder());
        }

        public ImprovedCauldron detect(BlockWorldVector pos) throws InvalidMechanismException {
            if (this.isCauldron(pos)) {
                return new ImprovedCauldron(this.plugin, BukkitUtil.toBlock((BlockWorldVector)pos), this.recipes);
            }
            return null;
        }

        private boolean isCauldron(BlockWorldVector pos) {
            Block block = BukkitUtil.toBlock((BlockWorldVector)pos);
            if (block.getTypeId() == 118) {
                Cauldron cauldron = (Cauldron)block.getState().getData();
                return block.getRelative(BlockFace.DOWN).getTypeId() == 51 && cauldron.isFull();
            }
            return false;
        }
    }
}

