/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.circuits;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.craftbook.ic.ICMechanic;
import com.sk89q.craftbook.ic.PipeInputIC;
import com.sk89q.craftbook.util.GeneralUtil;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.PistonBaseMaterial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pipes
extends AbstractMechanic {
    CircuitsPlugin plugin;
    private List<ItemStack> items = new ArrayList<ItemStack>();
    private List<BlockVector> visitedPipes = new ArrayList<BlockVector>();

    private Pipes(CircuitsPlugin plugin, BlockWorldVector pt) {
        this.plugin = plugin;
    }

    private Pipes(CircuitsPlugin plugin, BlockWorldVector pt, List<ItemStack> items) {
        this.plugin = plugin;
        this.items.addAll(items);
        this.startPipe(BukkitUtil.toBlock((BlockWorldVector)pt));
    }

    public void searchNearbyPipes(Block block) {
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    BlockVector bv;
                    Block off;
                    if (!this.plugin.getLocalConfiguration().pipeSettings.diagonals) {
                        if (x != 0 && y != 0 || x != 0 && z != 0 || y != 0 && z != 0) {
                            continue;
                        }
                    } else if (Math.abs(x) == Math.abs(y) && Math.abs(x) == Math.abs(z) && Math.abs(y) == Math.abs(z)) {
                        if (block.getRelative(x, 0, 0).getTypeId() == this.plugin.getLocalConfiguration().pipeSettings.insulator && block.getRelative(0, y, 0).getTypeId() == this.plugin.getLocalConfiguration().pipeSettings.insulator && block.getRelative(0, 0, z).getTypeId() == this.plugin.getLocalConfiguration().pipeSettings.insulator) {
                            continue;
                        }
                    } else if (Math.abs(x) == Math.abs(y)) {
                        if (block.getRelative(x, 0, 0).getTypeId() == this.plugin.getLocalConfiguration().pipeSettings.insulator && block.getRelative(0, y, 0).getTypeId() == this.plugin.getLocalConfiguration().pipeSettings.insulator) {
                            continue;
                        }
                    } else if (Math.abs(x) != Math.abs(z) ? Math.abs(y) == Math.abs(z) && block.getRelative(0, y, 0).getTypeId() == this.plugin.getLocalConfiguration().pipeSettings.insulator && block.getRelative(0, 0, z).getTypeId() == this.plugin.getLocalConfiguration().pipeSettings.insulator : block.getRelative(x, 0, 0).getTypeId() == this.plugin.getLocalConfiguration().pipeSettings.insulator && block.getRelative(0, 0, z).getTypeId() == this.plugin.getLocalConfiguration().pipeSettings.insulator) continue;
                    if (!this.isValidPipeBlock((off = block.getRelative(x, y, z)).getTypeId()) || this.visitedPipes.contains(bv = BukkitUtil.toVector((Block)off))) continue;
                    this.visitedPipes.add(bv);
                    if (off.getTypeId() == 20) {
                        this.searchNearbyPipes(off);
                        continue;
                    }
                    if (off.getTypeId() != 33) continue;
                    PistonBaseMaterial p = (PistonBaseMaterial)off.getState().getData();
                    Block fac = off.getRelative(p.getFacing());
                    if (fac.getTypeId() == 54 || fac.getTypeId() == 23) {
                        ArrayList newItems = new ArrayList();
                        for (ItemStack item : this.items) {
                            if (item == null) continue;
                            newItems.addAll(((InventoryHolder)fac.getState()).getInventory().addItem(new ItemStack[]{item}).values());
                        }
                        this.items.clear();
                        this.items.addAll(newItems);
                        if (this.items.isEmpty()) continue;
                        this.searchNearbyPipes(block);
                        continue;
                    }
                    if (fac.getTypeId() != 68 || CircuitsPlugin.getInst().icFactory == null) continue;
                    try {
                        ICMechanic icmech = CircuitsPlugin.getInst().icFactory.detect(BukkitUtil.toWorldVector((Block)fac));
                        if (icmech == null || !(icmech.getIC() instanceof PipeInputIC)) continue;
                        List<ItemStack> newItems = ((PipeInputIC)((Object)icmech.getIC())).onPipeTransfer(BukkitUtil.toWorldVector((Block)off), this.items);
                        this.items.clear();
                        this.items.addAll(newItems);
                        if (this.items.isEmpty()) continue;
                        this.searchNearbyPipes(block);
                        continue;
                    }
                    catch (Exception e) {
                        Bukkit.getLogger().severe(GeneralUtil.getStackTrace((Throwable)e));
                    }
                }
            }
        }
    }

    private boolean isValidPipeBlock(int typeId) {
        return typeId == 20 || typeId == 33 || typeId == 29 || typeId == 68;
    }

    public void startPipe(Block block) {
        block4: {
            block5: {
                this.visitedPipes.clear();
                if (block.getTypeId() != 29) break block4;
                PistonBaseMaterial p = (PistonBaseMaterial)block.getState().getData();
                Block fac = block.getRelative(p.getFacing());
                if (fac.getTypeId() != 54 && fac.getTypeId() != 23) break block5;
                this.items.addAll(Arrays.asList((Object[])((InventoryHolder)fac.getState()).getInventory().getContents().clone()));
                ((InventoryHolder)fac.getState()).getInventory().clear();
                this.visitedPipes.add(BukkitUtil.toVector((Block)fac));
                this.searchNearbyPipes(block);
                if (this.items.isEmpty()) break block4;
                for (ItemStack item : this.items) {
                    if (item == null) continue;
                    ((InventoryHolder)fac.getState()).getInventory().addItem(new ItemStack[]{item});
                }
                break block4;
            }
            if (!this.items.isEmpty()) {
                this.searchNearbyPipes(block);
                if (!this.items.isEmpty()) {
                    for (ItemStack item : this.items) {
                        if (item == null) continue;
                        block.getWorld().dropItemNaturally(block.getLocation().add(0.5, 0.5, 0.5), item);
                    }
                }
            }
        }
    }

    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        this.startPipe(event.getBlock());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Pipes> {
        CircuitsPlugin plugin;

        public Factory(CircuitsPlugin plugin) {
            this.plugin = plugin;
        }

        public Pipes detect(BlockWorldVector pt) {
            int type = BukkitUtil.toWorld((WorldVector)pt).getBlockTypeIdAt(BukkitUtil.toLocation((WorldVector)pt));
            if (type == 29 || type == 33) {
                return new Pipes(this.plugin, pt);
            }
            return null;
        }

        public Pipes detect(BlockWorldVector pt, List<ItemStack> items) {
            int type = BukkitUtil.toWorld((WorldVector)pt).getBlockTypeIdAt(BukkitUtil.toLocation((WorldVector)pt));
            if (type == 29 || type == 33) {
                return new Pipes(this.plugin, pt, items);
            }
            return null;
        }
    }
}

