/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.logic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICVerificationException;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

public class LowDelayer
extends AbstractIC {
    private int taskId;

    public LowDelayer(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    public String getTitle() {
        return "Low Delayer";
    }

    public String getSignTitle() {
        return "LOW_DELAYER";
    }

    public void trigger(final ChipState chip) {
        long delay = Long.parseLong(this.getSign().getLine(2));
        if (chip.getInput(0)) {
            Bukkit.getScheduler().cancelTask(this.taskId);
            chip.setOutput(0, true);
        } else {
            this.taskId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)CircuitsPlugin.getInst(), new Runnable(){

                public void run() {
                    if (!chip.getInput(0)) {
                        chip.setOutput(0, false);
                    }
                }
            }, delay * 20L);
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new LowDelayer(this.getServer(), sign, this);
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            try {
                Integer.parseInt(sign.getLine(2));
            }
            catch (Exception ignored) {
                throw new ICVerificationException("The third line needs to be a number.");
            }
        }
    }
}

