/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.FallingBlock;
import org.bukkit.util.Vector;

public class BlockLauncher
extends AbstractIC {
    Vector velocity;
    int id;
    byte data;

    public BlockLauncher(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    public String getTitle() {
        return "Block Launcher";
    }

    public String getSignTitle() {
        return "BLOCK LAUNCH";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.launch();
        }
    }

    public void load() {
        try {
            String[] split = RegexUtil.COLON_PATTERN.split(this.getSign().getLine(2));
            this.id = Integer.parseInt(split[0]);
            this.data = Byte.parseByte(split[1]);
        }
        catch (Exception ignored) {
            this.id = 12;
            this.data = 0;
        }
        try {
            String[] split2 = RegexUtil.COLON_PATTERN.split(this.getSign().getLine(3));
            this.velocity = new Vector(Double.parseDouble(split2[0]), Double.parseDouble(split2[1]), Double.parseDouble(split2[2]));
        }
        catch (Exception ignored) {
            this.velocity = new Vector(0.0, 0.5, 0.0);
        }
    }

    public void launch() {
        int timeout;
        Block above = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(0, 1, 0);
        for (timeout = 12; above.getTypeId() != 0 || timeout < 0 || above.getLocation().getY() >= 255.0; --timeout) {
            above = above.getRelative(0, 1, 0);
        }
        if (this.velocity.getY() < 0.0) {
            above = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(0, -1, 0);
            for (timeout = 12; above.getTypeId() != 0 || timeout < 0 || above.getLocation().getY() <= 1.0; --timeout) {
                above = above.getRelative(0, -1, 0);
            }
        }
        double y = (double)above.getY() - 0.99;
        FallingBlock block = BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().spawnFallingBlock(new Location(BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld(), (double)above.getX() + 0.5, y, (double)above.getZ() + 0.5), this.id, this.data);
        block.setVelocity(this.velocity);
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new BlockLauncher(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Launches set block with set velocity.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"id:data", "velocity x:y:z"};
            return lines;
        }
    }
}

