/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import org.bukkit.Server;
import org.bukkit.block.Block;

public class LavaSensor
extends AbstractIC {
    private Block center;

    public LavaSensor(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        this.center = ICUtil.parseBlockLocation(this.getSign());
    }

    public String getTitle() {
        return "Lava Sensor";
    }

    public String getSignTitle() {
        return "LAVA SENSOR";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.hasLava());
        }
    }

    protected boolean hasLava() {
        int blockID = this.center.getTypeId();
        return blockID == 10 || blockID == 11;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new LavaSensor(this.getServer(), sign, this);
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }

        public String getDescription() {
            return "Outputs high if lava is at given offset.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"x:y:z Offset", null};
            return lines;
        }
    }
}

