/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BlockType;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class Planter
extends AbstractIC {
    ItemStack item;
    Block target;
    Block onBlock;
    Vector offset;
    int radius;

    public Planter(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    public void load() {
        this.item = ICUtil.getItem(this.getLine(2));
        if (this.item == null) {
            this.item = new ItemStack(295, 1);
        }
        this.onBlock = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        try {
            this.radius = Integer.parseInt(RegexUtil.EQUALS_PATTERN.split(this.getSign().getLine(3))[0]);
            try {
                String[] loc = RegexUtil.COLON_PATTERN.split(RegexUtil.EQUALS_PATTERN.split(this.getSign().getLine(3))[1]);
                this.offset = new Vector(Integer.parseInt(loc[0]), Integer.parseInt(loc[1]), Integer.parseInt(loc[2]));
                if (this.offset.getX() > 16.0) {
                    this.offset.setX(16);
                }
                if (this.offset.getY() > 16.0) {
                    this.offset.setY(16);
                }
                if (this.offset.getZ() > 16.0) {
                    this.offset.setZ(16);
                }
                if (this.offset.getX() < -16.0) {
                    this.offset.setX(-16);
                }
                if (this.offset.getY() < -16.0) {
                    this.offset.setY(-16);
                }
                if (this.offset.getZ() < -16.0) {
                    this.offset.setZ(-16);
                }
            }
            catch (Exception e) {
                this.offset = new Vector(0, 2, 0);
            }
        }
        catch (Exception e) {
            this.radius = 10;
            this.offset = new Vector(0, 2, 0);
        }
        this.target = this.onBlock.getRelative(this.offset.getBlockX(), this.offset.getBlockY(), this.offset.getBlockZ());
    }

    public String getTitle() {
        return "Planter";
    }

    public String getSignTitle() {
        return "PLANTER";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.plant());
        }
    }

    public boolean plant() {
        if (!this.plantableItem(this.item.getTypeId())) {
            return false;
        }
        if (this.onBlock.getRelative(0, 1, 0).getTypeId() == 54) {
            Chest c = (Chest)this.onBlock.getRelative(0, 1, 0).getState();
            for (ItemStack it : c.getInventory().getContents()) {
                if (!ItemUtil.isStackValid((ItemStack)it) || it.getTypeId() != this.item.getTypeId() || this.item.getDurability() != 0 && it.getDurability() != this.item.getDurability()) continue;
                Block b = null;
                b = this.searchBlocks(it);
                if (b == null || !c.getInventory().removeItem(new ItemStack[]{new ItemStack(it.getTypeId(), 1, it.getDurability())}).isEmpty()) continue;
                b.setTypeIdAndData(this.getBlockByItem(this.item.getTypeId()), (byte)this.item.getDurability(), true);
                return true;
            }
        } else {
            for (Entity ent : this.target.getChunk().getEntities()) {
                double diffZ;
                double diffY;
                Item itemEnt;
                if (!(ent instanceof Item) || !ItemUtil.isStackValid((ItemStack)(itemEnt = (Item)ent).getItemStack()) || itemEnt.getItemStack().getTypeId() != this.item.getTypeId() || this.item.getDurability() != 0 && itemEnt.getItemStack().getDurability() != this.item.getDurability() && itemEnt.getItemStack().getData().getData() != this.item.getData().getData()) continue;
                Location loc = itemEnt.getLocation();
                double diffX = (double)this.target.getX() - loc.getX();
                if (!(diffX * diffX + (diffY = (double)this.target.getY() - loc.getY()) * diffY + (diffZ = (double)this.target.getZ() - loc.getZ()) * diffZ < (double)(this.radius * this.radius))) continue;
                Block b = null;
                b = this.searchBlocks(itemEnt.getItemStack());
                if (b == null || !ItemUtil.takeFromEntity((Item)itemEnt)) continue;
                b.setTypeIdAndData(this.getBlockByItem(this.item.getTypeId()), (byte)this.item.getDurability(), true);
                return true;
            }
        }
        return false;
    }

    public Block searchBlocks(ItemStack stack) {
        for (int x = -this.radius + 1; x < this.radius; ++x) {
            for (int y = -this.radius + 1; y < this.radius; ++y) {
                for (int z = -this.radius + 1; z < this.radius; ++z) {
                    int rx = this.target.getX() - x;
                    int ry = this.target.getY() - y;
                    int rz = this.target.getZ() - z;
                    Block b = BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().getBlockAt(rx, ry, rz);
                    if (b.getTypeId() != 0 || !this.itemPlantableOnBlock(this.item.getTypeId(), b.getRelative(0, -1, 0).getTypeId())) continue;
                    return b;
                }
            }
        }
        return null;
    }

    protected boolean plantableItem(int itemId) {
        switch (itemId) {
            case 6: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 81: 
            case 295: 
            case 361: 
            case 362: 
            case 372: 
            case 391: 
            case 392: {
                return true;
            }
        }
        return false;
    }

    protected boolean itemPlantableOnBlock(int itemId, int blockId) {
        switch (itemId) {
            case 6: 
            case 37: 
            case 38: {
                return blockId == 3 || blockId == 2;
            }
            case 295: 
            case 361: 
            case 362: 
            case 392: {
                return blockId == 60;
            }
            case 372: {
                return blockId == 88;
            }
            case 81: {
                return blockId == 12;
            }
            case 39: 
            case 40: {
                return !BlockType.canPassThrough((int)blockId);
            }
        }
        return false;
    }

    protected int getBlockByItem(int itemId) {
        switch (itemId) {
            case 295: {
                return 59;
            }
            case 362: {
                return 105;
            }
            case 361: {
                return 104;
            }
            case 6: {
                return 6;
            }
            case 372: {
                return 115;
            }
            case 81: {
                return 81;
            }
            case 392: {
                return 142;
            }
            case 391: {
                return 141;
            }
            case 38: {
                return 38;
            }
            case 37: {
                return 37;
            }
            case 40: {
                return 40;
            }
            case 39: {
                return 39;
            }
        }
        return 0;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new Planter(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Plants plantable things at set offset.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"Item to plant id:data", "radius=x:y:z offset"};
            return lines;
        }
    }
}

