/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class SetDoor
extends AbstractIC {
    private int onMaterial;
    private int onData;
    private int offMaterial;
    private int offData;
    private int width;
    private int height;
    private int offsetX;
    private int offsetY;
    private int offsetZ;
    private Block center;
    private BlockFace faceing;

    public SetDoor(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    public void load() {
        this.center = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        this.faceing = SignUtil.getFacing((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        String line = this.getSign().getLine(2);
        if (!line.isEmpty()) {
            try {
                String[] strings;
                String[] split = RegexUtil.MINUS_PATTERN.split(line);
                if (split.length > 0) {
                    try {
                        strings = RegexUtil.COLON_PATTERN.split(split[1]);
                        this.offMaterial = Integer.parseInt(strings[0]);
                        if (strings.length > 0) {
                            this.offData = Integer.parseInt(strings[1]);
                        }
                    }
                    catch (NumberFormatException e) {
                        this.offMaterial = 0;
                        this.offData = 0;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        this.offData = 0;
                    }
                }
                strings = RegexUtil.COLON_PATTERN.split(split[0]);
                this.onMaterial = Integer.parseInt(strings[0]);
                if (strings.length > 0) {
                    this.onData = Integer.parseInt(strings[1]);
                }
            }
            catch (NumberFormatException e) {
                this.onMaterial = 1;
                this.onData = 0;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.onData = 0;
            }
        }
        if (!(line = this.getSign().getLine(3)).isEmpty()) {
            boolean relativeOffset;
            boolean bl = relativeOffset = !line.contains("!");
            if (!relativeOffset) {
                line = line.replace("!", "");
            }
            String[] split = RegexUtil.COLON_PATTERN.split(line);
            try {
                String[] offsetSplit = RegexUtil.COMMA_PATTERN.split(split[0]);
                this.offsetX = Integer.parseInt(offsetSplit[0]);
                this.offsetY = Integer.parseInt(offsetSplit[1]);
                this.offsetZ = Integer.parseInt(offsetSplit[2]);
            }
            catch (NumberFormatException e) {
                this.offsetX = 0;
                this.offsetY = 0;
                this.offsetZ = 0;
            }
            catch (IndexOutOfBoundsException e) {
                this.offsetX = 0;
                this.offsetY = 0;
                this.offsetZ = 0;
            }
            try {
                String[] sizeSplit = RegexUtil.COMMA_PATTERN.split(split[1]);
                this.width = Integer.parseInt(sizeSplit[0]);
                this.height = Integer.parseInt(sizeSplit[1]);
            }
            catch (NumberFormatException e) {
                this.width = 1;
                this.height = 1;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.height = 1;
            }
            this.center = relativeOffset ? LocationUtil.getRelativeOffset((ChangedSign)this.getSign(), (int)this.offsetX, (int)this.offsetY, (int)this.offsetZ) : LocationUtil.getOffset((Block)this.center, (int)this.offsetX, (int)this.offsetY, (int)this.offsetZ);
        } else {
            this.center = this.center.getRelative(BlockFace.UP);
        }
    }

    public String getTitle() {
        return "Set P-Door";
    }

    public String getSignTitle() {
        return "SET P-DOOR";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.setDoor(true);
        } else {
            this.setDoor(false);
        }
    }

    private void setDoor(boolean open) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                Block block = LocationUtil.getRelativeOffset((Block)this.center, (BlockFace)this.faceing, (int)x, (int)y, (int)0);
                if (open) {
                    block.setTypeIdAndData(this.onMaterial, (byte)this.onData, true);
                    continue;
                }
                block.setTypeIdAndData(this.offMaterial, (byte)this.offData, true);
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new SetDoor(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Generates a door out of the set materials with set size.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"onID:onData-offID:offData", "offset x,y,z:width,height"};
            return lines;
        }
    }
}

