/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.blocks;

import com.sk89q.craftbook.BaseConfiguration;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.util.SignUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spigot
extends AbstractIC {
    int radius;
    int yOffset;

    public Spigot(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public void load() {
        try {
            this.radius = Integer.parseInt(this.getSign().getLine(2));
        }
        catch (Exception ignored) {
            this.radius = 15;
        }
        try {
            this.yOffset = Integer.parseInt(this.getSign().getLine(3));
        }
        catch (Exception ignored) {
            this.yOffset = 1;
        }
    }

    @Override
    public String getTitle() {
        return "Spigot";
    }

    @Override
    public String getSignTitle() {
        return "SPIGOT";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.search());
        }
    }

    public boolean search() {
        Block off = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(0, this.yOffset, 0);
        ArrayList<Location> searched = new ArrayList<Location>();
        return this.searchAt(searched, off);
    }

    public boolean searchAt(ArrayList<Location> searched, Block off) {
        if (searched.contains(off.getLocation())) {
            return false;
        }
        searched.add(off.getLocation());
        if (off.getLocation().distanceSquared(SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock().getRelative(0, this.yOffset, 0)).getLocation()) > (double)(this.radius * this.radius)) {
            return false;
        }
        if (off.getTypeId() == 0) {
            int m = this.getFromChest();
            if (m == 0) {
                return false;
            }
            off.setTypeId(this.parse(m));
            return true;
        }
        if (off.isLiquid()) {
            if (off.getData() != 0) {
                int m = this.getFromChest(off.getTypeId());
                if (m == 0) {
                    return false;
                }
                off.setTypeId(m);
                return true;
            }
            if (this.searchAt(searched, off.getRelative(1, 0, 0))) {
                return true;
            }
            if (this.searchAt(searched, off.getRelative(-1, 0, 0))) {
                return true;
            }
            if (this.searchAt(searched, off.getRelative(0, 0, 1))) {
                return true;
            }
            if (this.searchAt(searched, off.getRelative(0, 0, -1))) {
                return true;
            }
            if (this.searchAt(searched, off.getRelative(0, 1, 0))) {
                return true;
            }
        }
        return false;
    }

    public int getFromChest() {
        Block chest = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(0, -1, 0);
        if (chest.getTypeId() == 54) {
            Chest c = (Chest)chest.getState();
            if (((Factory)this.getFactory()).buckets) {
                HashMap over = c.getInventory().removeItem(new ItemStack[]{new ItemStack(326, 1)});
                if (over.isEmpty()) {
                    return 8;
                }
                over = c.getInventory().removeItem(new ItemStack[]{new ItemStack(327, 1)});
                if (over.isEmpty()) {
                    return 10;
                }
            } else {
                HashMap over = c.getInventory().removeItem(new ItemStack[]{new ItemStack(8, 1)});
                if (over.isEmpty()) {
                    return 8;
                }
                over = c.getInventory().removeItem(new ItemStack[]{new ItemStack(9, 1)});
                if (over.isEmpty()) {
                    return 8;
                }
                over = c.getInventory().removeItem(new ItemStack[]{new ItemStack(10, 1)});
                if (over.isEmpty()) {
                    return 10;
                }
                over = c.getInventory().removeItem(new ItemStack[]{new ItemStack(11, 1)});
                if (over.isEmpty()) {
                    return 10;
                }
            }
        }
        return 0;
    }

    public int getFromChest(int m) {
        m = this.parse(m);
        Block chest = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(0, -1, 0);
        if (chest.getTypeId() == 54) {
            Chest c = (Chest)chest.getState();
            if (((Factory)this.getFactory()).buckets) {
                HashMap over = c.getInventory().removeItem(new ItemStack[]{new ItemStack(m == 10 ? 327 : 326, 1)});
                if (over.isEmpty()) {
                    return m;
                }
            } else {
                HashMap over = c.getInventory().removeItem(new ItemStack[]{new ItemStack(m, 1)});
                if (over.isEmpty()) {
                    return m;
                }
                over = c.getInventory().removeItem(new ItemStack[]{new ItemStack(this.unparse(m), 1)});
                if (over.isEmpty()) {
                    return m;
                }
            }
        }
        return 0;
    }

    public int parse(int mat) {
        if (mat == 9 || mat == 8) {
            return 8;
        }
        if (mat == 11 || mat == 10) {
            return 10;
        }
        return 0;
    }

    public int unparse(int mat) {
        if (mat == 9 || mat == 8) {
            return 9;
        }
        if (mat == 11 || mat == 10) {
            return 11;
        }
        return 0;
    }

    public static class Factory
    extends AbstractICFactory {
        public boolean buckets;

        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new Spigot(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Fills areas with liquid from below chest.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"radius", "y offset"};
            return lines;
        }

        public void addConfiguration(BaseConfiguration.BaseConfigurationSection section) {
            this.buckets = section.getBoolean("requires-buckets", false);
        }

        public boolean needsConfiguration() {
            return true;
        }
    }
}

