/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.items;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.block.Furnace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ContainerCollector
extends AbstractIC {
    ItemStack doWant;
    ItemStack doNotWant;

    public ContainerCollector(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Container Collector";
    }

    public String getSignTitle() {
        return "CONTAINER COLLECT";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.collect());
        }
    }

    public void load() {
        this.doWant = ICUtil.getItem(this.getSign().getLine(2));
        this.doNotWant = ICUtil.getItem(this.getSign().getLine(3));
    }

    protected boolean collect() {
        Block b = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        int x = b.getX();
        int y = b.getY() + 1;
        int z = b.getZ();
        Block bl = BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock().getWorld().getBlockAt(x, y, z);
        boolean collected = false;
        for (Entity en : BukkitUtil.toSign((ChangedSign)this.getSign()).getChunk().getEntities()) {
            Item item;
            ItemStack stack;
            if (!(en instanceof Item) || !ItemUtil.isStackValid((ItemStack)(stack = (item = (Item)en).getItemStack())) || item.isDead() || !item.isValid()) continue;
            Location location = item.getLocation();
            int ix = location.getBlockX();
            int iy = location.getBlockY();
            int iz = location.getBlockZ();
            if (ix != this.getSign().getX() || iy != this.getSign().getY() || iz != this.getSign().getZ() || this.doWant != null && !ItemUtil.areItemsIdentical((ItemStack)this.doWant, (ItemStack)stack) || this.doNotWant != null && ItemUtil.areItemsIdentical((ItemStack)this.doNotWant, (ItemStack)stack) || !this.addToContainer(bl, stack)) continue;
            item.remove();
            collected = true;
        }
        return collected;
    }

    private boolean addToContainer(Block bl, ItemStack stack) {
        int type = bl.getTypeId();
        if (type == 54 || type == 23) {
            BlockState state = bl.getState();
            Inventory inventory = ((InventoryHolder)state).getInventory();
            if (inventory.firstEmpty() != -1) {
                inventory.addItem(new ItemStack[]{stack});
                state.update();
                return true;
            }
        } else if (type == 117) {
            if (!ItemUtil.isAPotionIngredient((ItemStack)stack)) {
                return false;
            }
            BrewingStand brewingStand = (BrewingStand)bl.getState();
            BrewerInventory inv = brewingStand.getInventory();
            if (ContainerCollector.fitsInSlot(stack, inv.getIngredient())) {
                if (inv.getIngredient() == null) {
                    inv.setIngredient(stack);
                } else {
                    ItemUtil.addToStack((ItemStack)inv.getIngredient(), (ItemStack)stack);
                }
                brewingStand.update();
                return true;
            }
        } else if (type == 61 || type == 62) {
            Furnace furnace = (Furnace)bl.getState();
            FurnaceInventory inv = furnace.getInventory();
            if (ItemUtil.isFurnacable((ItemStack)stack) && ContainerCollector.fitsInSlot(stack, inv.getSmelting())) {
                if (inv.getSmelting() == null) {
                    inv.setSmelting(stack);
                } else {
                    ItemUtil.addToStack((ItemStack)inv.getSmelting(), (ItemStack)stack);
                }
                furnace.update();
                return true;
            }
            if (ItemUtil.isAFuel((ItemStack)stack) && ContainerCollector.fitsInSlot(stack, inv.getFuel())) {
                if (inv.getFuel() == null) {
                    inv.setFuel(stack);
                } else {
                    ItemUtil.addToStack((ItemStack)inv.getFuel(), (ItemStack)stack);
                }
                furnace.update();
                return true;
            }
        }
        return false;
    }

    private static boolean fitsInSlot(ItemStack stack, ItemStack slot) {
        return slot == null || ItemUtil.areItemsIdentical((ItemStack)stack, (ItemStack)slot);
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new ContainerCollector(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Collects items into above chest.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"included id:data", "excluded id:data"};
            return lines;
        }
    }
}

