/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.items;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.PipeInputIC;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockWorldVector;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.PistonBaseMaterial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sorter
extends AbstractIC
implements PipeInputIC {
    Block chestBlock;
    boolean inverted;

    public Sorter(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.chestBlock = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(0, 1, 0);
        this.inverted = this.getSign().getLine(2).equalsIgnoreCase("invert");
    }

    @Override
    public String getTitle() {
        return "Sorter";
    }

    @Override
    public String getSignTitle() {
        return "SORTER";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.sort());
        }
    }

    public boolean sort() {
        boolean returnValue = false;
        for (Entity en : BukkitUtil.toSign((ChangedSign)this.getSign()).getChunk().getEntities()) {
            PistonBaseMaterial p;
            Block fac;
            Item item;
            ItemStack stack;
            if (!(en instanceof Item) || !ItemUtil.isStackValid((ItemStack)(stack = (item = (Item)en).getItemStack())) || item.isDead() || !item.isValid()) continue;
            Location location = item.getLocation();
            int ix = location.getBlockX();
            int iy = location.getBlockY();
            int iz = location.getBlockZ();
            if (ix != this.getSign().getX() || iy != this.getSign().getY() || iz != this.getSign().getZ()) continue;
            BlockFace back = SignUtil.getBack((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
            Block b = this.isInAboveChest(stack) || this.inverted ? SignUtil.getRightBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(back) : SignUtil.getLeftBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(back);
            boolean pipes = false;
            if (b.getTypeId() == 29 && (fac = b.getRelative((p = (PistonBaseMaterial)b.getState().getData()).getFacing())).getLocation().equals((Object)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock().getRelative(back).getLocation())) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                items.add(item.getItemStack());
                if (CircuitsPlugin.getInst().pipeFactory != null && CircuitsPlugin.getInst().pipeFactory.detect(BukkitUtil.toWorldVector((Block)b), items) != null) {
                    item.remove();
                    pipes = true;
                    returnValue = true;
                }
            }
            if (!pipes) {
                item.teleport(b.getLocation().add(0.5, 0.5, 0.5));
            }
            returnValue = true;
        }
        return returnValue;
    }

    public void sortItem(ItemStack item) {
        PistonBaseMaterial p;
        Block fac;
        BlockFace back = SignUtil.getBack((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        Block b = this.isInAboveChest(item) || this.inverted ? SignUtil.getRightBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(back) : SignUtil.getLeftBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(back);
        boolean pipes = false;
        if (b.getTypeId() == 29 && (fac = b.getRelative((p = (PistonBaseMaterial)b.getState().getData()).getFacing())).getLocation().equals((Object)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock().getRelative(back).getLocation())) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(item);
            if (CircuitsPlugin.getInst().pipeFactory != null && CircuitsPlugin.getInst().pipeFactory.detect(BukkitUtil.toWorldVector((Block)b), items) != null) {
                pipes = true;
            }
        }
        if (!pipes) {
            b.getWorld().dropItemNaturally(b.getLocation().add(0.5, 0.5, 0.5), item);
        }
    }

    public boolean isInAboveChest(ItemStack item) {
        if (this.chestBlock.getTypeId() == 54) {
            Chest chest = (Chest)this.chestBlock.getState();
            return chest.getInventory().contains(new ItemStack(item.getTypeId(), 1, item.getDurability()));
        }
        return false;
    }

    @Override
    public List<ItemStack> onPipeTransfer(BlockWorldVector pipe, List<ItemStack> items) {
        for (ItemStack item : items) {
            if (!ItemUtil.isStackValid((ItemStack)item)) continue;
            this.sortItem(item);
        }
        return new ArrayList<ItemStack>();
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new Sorter(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Sorts items and spits out left/right depending on above chest.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"invert - to invert output sides", null};
            return lines;
        }
    }
}

