/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.SmallFireball;
import org.bukkit.util.Vector;

public class FireShooter
extends AbstractIC {
    private float speed;
    private float spread;
    private float vert;

    public FireShooter(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        String[] velocity = RegexUtil.COLON_PATTERN.split(this.getSign().getLine(2).trim(), 2);
        try {
            this.speed = Float.parseFloat(velocity[0]);
            this.spread = Float.parseFloat(velocity[1]);
        }
        catch (Exception ignored) {
            this.speed = 0.6f;
            this.spread = 4.0f;
        }
        try {
            this.vert = Float.parseFloat(this.getSign().getLine(3).trim());
        }
        catch (Exception ignored) {
            this.vert = 0.0f;
        }
        if ((double)this.speed > 2.0) {
            this.speed = 2.0f;
        } else if ((double)this.speed < 0.2) {
            this.speed = 0.2f;
        }
        if (this.spread > 50.0f) {
            this.spread = 50.0f;
        } else if (this.spread < 0.0f) {
            this.spread = 0.0f;
        }
        if (this.vert > 1.0f) {
            this.vert = 1.0f;
        } else if (this.vert < -1.0f) {
            this.vert = -1.0f;
        }
    }

    public String getTitle() {
        return "Fire Shooter";
    }

    public String getSignTitle() {
        return "FIRE SHOOTER";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.shootFire(1);
        }
    }

    public void shootFire(int n) {
        Block signBlock = BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock();
        BlockFace face = SignUtil.getBack((Block)signBlock);
        Block targetDir = signBlock.getRelative(face).getRelative(face);
        float x = targetDir.getX() - signBlock.getX();
        float z = targetDir.getZ() - signBlock.getZ();
        Vector velocity = new Vector(x, this.vert, z);
        Location shootLoc = new Location(BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld(), (double)targetDir.getX() + 0.5, (double)targetDir.getY() + 0.5, (double)targetDir.getZ() + 0.5);
        if (n != 1) {
            for (int i = 0; i < n; i = (int)((short)(i + 1))) {
                velocity = new Vector(x + FireShooter.randomFloat(this.spread), this.vert + FireShooter.randomFloat(this.spread), z + FireShooter.randomFloat(this.spread));
                SmallFireball f = (SmallFireball)BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().spawn(shootLoc, SmallFireball.class);
                f.setVelocity(velocity);
            }
        } else {
            SmallFireball f = (SmallFireball)BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().spawn(shootLoc, SmallFireball.class);
            f.setVelocity(velocity);
        }
    }

    private static float randomFloat(float width) {
        return (BaseBukkitPlugin.random.nextFloat() - 0.5f) * width;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new FireShooter(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Shoots a fireball.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"speed:spread", "vertical gain"};
            return lines;
        }
    }
}

