/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionInducer
extends AbstractIC {
    int radius;
    int effectID;
    int effectAmount;
    int effectTime;
    boolean mobs;
    boolean players;

    public PotionInducer(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Potion Inducer";
    }

    public String getSignTitle() {
        return "POTION INDUCER";
    }

    public void load() {
        String[] effectInfo = RegexUtil.COLON_PATTERN.split(this.getLine(2), 3);
        this.effectID = Integer.parseInt(effectInfo[0]);
        try {
            this.effectAmount = Integer.parseInt(effectInfo[1]);
        }
        catch (Exception e) {
            this.effectAmount = 1;
        }
        try {
            this.effectTime = Integer.parseInt(effectInfo[2]);
        }
        catch (Exception e) {
            this.effectTime = 10;
        }
        String line4 = this.getSign().getLine(3).toLowerCase();
        if (line4.contains("pm")) {
            this.mobs = true;
            this.players = true;
        } else if (line4.contains("m")) {
            this.mobs = true;
            this.players = false;
        } else if (line4.contains("p")) {
            this.players = true;
            this.mobs = false;
        } else {
            this.players = true;
            this.mobs = false;
        }
        line4 = line4.replace("m", "").replace("p", "");
        try {
            this.radius = Integer.parseInt(line4);
        }
        catch (Exception e) {
            this.radius = 10;
        }
    }

    public boolean induce() {
        boolean value = false;
        Set chunks = LocationUtil.getSurroundingChunks((Block)SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()), (int)this.radius);
        for (Chunk chunk : chunks) {
            if (!chunk.isLoaded()) continue;
            for (Entity entity : chunk.getEntities()) {
                if (!entity.isValid() || !(entity instanceof LivingEntity)) continue;
                LivingEntity liv = (LivingEntity)entity;
                if (!this.mobs && !(liv instanceof Player) || !this.players && liv instanceof Player || liv.getLocation().distanceSquared(BukkitUtil.toSign((ChangedSign)this.getSign()).getLocation()) > (double)(this.radius * this.radius)) continue;
                liv.addPotionEffect(new PotionEffect(PotionEffectType.getById((int)this.effectID), this.effectTime * 20, this.effectAmount - 1), true);
                value = true;
            }
        }
        return value;
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.induce());
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new PotionInducer(this.getServer(), sign, this);
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            try {
                String[] bits = RegexUtil.COLON_PATTERN.split(sign.getLine(2), 3);
                int effectId = Integer.parseInt(bits[0]);
                if (PotionEffectType.getById((int)effectId) == null) {
                    throw new ICVerificationException("The third line must be a valid potion effect id.");
                }
            }
            catch (NumberFormatException e) {
                throw new ICVerificationException("The third line must be a valid potion effect id.");
            }
        }

        public String getDescription() {
            return "Gives nearby entities a potion effect.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"id:level:time", "range (add a m to the end to only induce mobs or p for players (pm for both))"};
            return lines;
        }
    }
}

