/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.gates.world.sensors.ItemSensor;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import org.bukkit.Server;

public class ItemNotSensor
extends ItemSensor {
    public ItemNotSensor(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    public String getTitle() {
        return "Item Not Sensor";
    }

    public String getSignTitle() {
        return "ITEM NOT SENSOR";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, !this.isDetected());
        }
    }

    public static class Factory
    extends ItemSensor.Factory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new ItemNotSensor(this.getServer(), sign, this);
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }

        public String getDescription() {
            return "Detects if an item is NOT within a given radius";
        }
    }
}

