/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.blocks.ItemType;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class ItemSensor
extends AbstractIC {
    private int item;
    private short data;
    private Block center;
    private Set<Chunk> chunks;
    private int radius;

    public ItemSensor(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    public void load() {
        String[] split;
        Block block;
        block4: {
            block = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
            split = RegexUtil.COLON_PATTERN.split(this.getSign().getLine(3).trim());
            try {
                this.item = Integer.parseInt(split[0]);
            }
            catch (NumberFormatException e) {
                BlockType material = BlockType.lookup((String)split[0]);
                if (material != null) {
                    this.item = material.getID();
                }
                ItemType it = ItemType.lookup((String)split[0]);
                if (it == null) break block4;
                this.item = it.getID();
            }
        }
        if (this.item == 0) {
            this.item = 1;
        }
        this.data = split.length > 1 ? Short.parseShort(split[1]) : (short)-1;
        this.radius = ICUtil.parseRadius(this.getSign());
        this.center = this.getSign().getLine(2).contains("=") ? ICUtil.parseBlockLocation(this.getSign()) : SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        this.chunks = LocationUtil.getSurroundingChunks((Block)block, (int)this.radius);
    }

    public String getTitle() {
        return "Item Detection";
    }

    public String getSignTitle() {
        return "ITEM DETECTION";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.isDetected());
        }
    }

    protected boolean isDetected() {
        for (Chunk chunk : this.chunks) {
            if (!chunk.isLoaded()) continue;
            for (Entity entity : chunk.getEntities()) {
                ItemStack itemStack;
                if (!(entity instanceof Item) || (itemStack = ((Item)entity).getItemStack()).getTypeId() != this.item) continue;
                if (this.data != -1 && itemStack.getDurability() != this.data) {
                    return false;
                }
                if (!LocationUtil.isWithinRadius((Location)this.center.getLocation(), (Location)entity.getLocation(), (int)this.radius)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new ItemSensor(this.getServer(), sign, this);
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }

        public String getDescription() {
            return "Detects items within a given radius";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"radius=x:y:z offset", "id:data"};
            return lines;
        }
    }
}

