/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Server;
import org.bukkit.block.Block;

public class LightSensor
extends AbstractIC {
    int x;
    int y;
    int z;
    byte min;

    public LightSensor(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Light Sensor";
    }

    public String getSignTitle() {
        return "LIGHT SENSOR";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.getTargetLighted());
        }
    }

    public void load() {
        try {
            String[] st = RegexUtil.COLON_PATTERN.split(this.getSign().getLine(3));
            if (st.length != 3) {
                throw new Exception();
            }
            this.x = Integer.parseInt(st[0]);
            this.y = Integer.parseInt(st[1]);
            this.z = Integer.parseInt(st[2]);
        }
        catch (Exception ignored) {
            this.x = 0;
            this.y = 1;
            this.z = 0;
        }
        try {
            this.min = Byte.parseByte(this.getSign().getLine(2));
        }
        catch (Exception e) {
            this.min = (byte)10;
            try {
                this.getSign().setLine(2, Integer.toString(this.min));
                this.getSign().update(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean getTargetLighted() {
        return this.hasLight(this.min, this.x, this.y, this.z);
    }

    private boolean hasLight(byte specifiedLevel, int x, int y, int z) {
        Block signBlock = BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock();
        Block backBlock = signBlock.getRelative(SignUtil.getBack((Block)signBlock));
        byte lightLevel = backBlock.getRelative(x, y, z).getLightLevel();
        return lightLevel >= specifiedLevel;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new LightSensor(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Outputs high if specific block is above specified light level.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"minimum light", "x:y:z offset"};
            return lines;
        }
    }
}

