/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.GeneralUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class PlayerSensor
extends AbstractIC {
    int radius;
    Location location;
    ProtectedRegion reg;
    Type type;
    String nameLine;

    public PlayerSensor(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    public String getTitle() {
        return "Player Detection";
    }

    public String getSignTitle() {
        return "P-DETECTION";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.isDetected());
        }
    }

    public void load() {
        if (this.getLine(3).contains(":")) {
            this.type = Type.getFromChar(this.getLine(3).trim().toCharArray()[0]);
        }
        if (this.type == null) {
            this.type = Type.PLAYER;
        }
        this.nameLine = this.getSign().getLine(3).replace("g:", "").replace("p:", "").trim();
        try {
            String locInfo = this.getLine(2);
            if (locInfo.startsWith("r:") && CircuitsPlugin.getInst().getWorldGuard() != null) {
                locInfo = locInfo.replace("r:", "");
                this.reg = CircuitsPlugin.getInst().getWorldGuard().getRegionManager(BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld()).getRegion(locInfo);
                if (this.reg != null) {
                    return;
                }
            }
            this.radius = ICUtil.parseRadius(this.getSign());
            this.location = locInfo.contains("=") ? ICUtil.parseBlockLocation(this.getSign()).getLocation() : SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getLocation();
        }
        catch (Exception e) {
            this.location = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getLocation();
            Bukkit.getLogger().severe(GeneralUtil.getStackTrace((Throwable)e));
        }
    }

    protected boolean isDetected() {
        if (this.reg != null) {
            for (Player p : BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().getPlayers()) {
                if (!this.reg.contains(p.getLocation().getBlockX(), p.getLocation().getBlockY(), p.getLocation().getBlockZ())) continue;
                return true;
            }
        }
        if (this.location != null) {
            Player p;
            if (!this.nameLine.isEmpty() && this.type == Type.PLAYER && (p = Bukkit.getPlayer((String)this.nameLine)) != null && LocationUtil.isWithinRadius((Location)this.location, (Location)p.getLocation(), (int)this.radius)) {
                return true;
            }
            for (Player e : this.getServer().getOnlinePlayers()) {
                if (e == null || !e.isValid() || !LocationUtil.isWithinRadius((Location)this.location, (Location)e.getLocation(), (int)this.radius)) continue;
                if (this.nameLine.isEmpty()) {
                    return true;
                }
                if (this.type == Type.PLAYER && e.getName().toLowerCase().startsWith(this.nameLine.toLowerCase())) {
                    return true;
                }
                if (this.type != Type.GROUP || !CircuitsPlugin.getInst().isInGroup(e.getName(), this.nameLine)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new PlayerSensor(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Detects players within a radius.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"radius=x:y:z offset, or r:regionname for WorldGuard regions", "p:playername or g:permissiongroup"};
            return lines;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        PLAYER('p'),
        GROUP('g');

        char prefix;

        private Type(char prefix) {
            this.prefix = prefix;
        }

        public static Type getFromChar(char c) {
            c = Character.toLowerCase(c);
            for (Type t : Type.values()) {
                if (t.prefix != c) continue;
                return t;
            }
            return null;
        }
    }
}

