/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.ic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.PersistentMechanic;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFamily;
import com.sk89q.craftbook.ic.ICManager;
import com.sk89q.craftbook.ic.PersistentIC;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICMechanic
extends PersistentMechanic {
    protected final CircuitsPlugin plugin;
    protected final String id;
    protected final ICFamily family;
    protected final IC ic;
    protected final BlockWorldVector pos;

    public ICMechanic(CircuitsPlugin plugin, String id, IC ic, ICFamily family, BlockWorldVector pos) {
        super(new BlockWorldVector[]{pos});
        this.plugin = plugin;
        this.id = id;
        this.ic = ic;
        this.family = family;
        this.pos = pos;
    }

    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        BlockWorldVector pt = (BlockWorldVector)this.getTriggerPositions().get(0);
        final Block block = BukkitUtil.toWorld((WorldVector)pt).getBlockAt(BukkitUtil.toLocation((WorldVector)pt));
        if (event.getNewCurrent() == event.getOldCurrent()) {
            return;
        }
        if (block.getTypeId() == 68) {
            final Block source = event.getSource();
            if (SignUtil.getBackBlock((Block)block).equals(source) || block.equals(source)) {
                return;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    if (block.getTypeId() != 68) {
                        return;
                    }
                    ChipState chipState = ICMechanic.this.family.detect(BukkitUtil.toWorldVector((Block)source), BukkitUtil.toChangedSign((Block)block));
                    int cnt = 0;
                    for (int i = 0; i < chipState.getInputCount(); ++i) {
                        if (!chipState.isTriggered(i)) continue;
                        ++cnt;
                    }
                    if (cnt > 0) {
                        ICMechanic.this.ic.trigger(chipState);
                    }
                }
            };
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, runnable, 2L);
        }
    }

    public void onRightClick(PlayerInteractEvent event) {
        this.ic.onRightClick(event.getPlayer());
    }

    public void unload() {
        this.ic.unload();
    }

    public boolean isActive() {
        BlockWorldVector pt = (BlockWorldVector)this.getTriggerPositions().get(0);
        Block block = BukkitUtil.toWorld((WorldVector)pt).getBlockAt(BukkitUtil.toLocation((WorldVector)pt));
        if (block.getTypeId() == 68 && block.getTypeId() == 68) {
            ChangedSign sign = BukkitUtil.toChangedSign((Block)block);
            Matcher matcher = RegexUtil.IC_PATTERN.matcher(sign.getLine(1));
            return matcher.matches() && matcher.group(1).equalsIgnoreCase(this.id) && this.ic instanceof PersistentIC && ((PersistentIC)this.ic).isActive();
        }
        return false;
    }

    public List<BlockWorldVector> getWatchedPositions() {
        return new ArrayList<BlockWorldVector>();
    }

    public void onBlockBreak(BlockBreakEvent event) {
        ICManager.removeCachedIC(this.pos);
    }

    public IC getIC() {
        return this.ic;
    }
}

