/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.cart;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.RedstoneUtil;
import com.sk89q.craftbook.cart.CartMechanismBlocks;
import com.sk89q.craftbook.util.ItemInfo;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;

public abstract class CartMechanism {
    protected ItemInfo material;
    public static final BlockFace[] powerSupplyOptions = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};

    public abstract void impact(Minecart var1, CartMechanismBlocks var2, boolean var3);

    public void enter(Minecart cart, Entity entity, CartMechanismBlocks blocks, boolean minor) {
    }

    void setMaterial(ItemInfo mat) {
        this.material = mat;
    }

    public RedstoneUtil.Power isActive(Block rail, Block base, Block sign) {
        boolean isWired = false;
        if (sign != null) {
            switch (this.isActive(sign)) {
                case ON: {
                    return RedstoneUtil.Power.ON;
                }
                case NA: {
                    break;
                }
                case OFF: {
                    isWired = true;
                }
            }
        }
        if (base != null) {
            switch (this.isActive(base)) {
                case ON: {
                    return RedstoneUtil.Power.ON;
                }
                case NA: {
                    break;
                }
                case OFF: {
                    isWired = true;
                }
            }
        }
        if (rail != null) {
            switch (this.isActive(rail)) {
                case ON: {
                    return RedstoneUtil.Power.ON;
                }
                case NA: {
                    break;
                }
                case OFF: {
                    isWired = true;
                }
            }
        }
        return isWired ? RedstoneUtil.Power.OFF : RedstoneUtil.Power.NA;
    }

    private RedstoneUtil.Power isActive(Block block) {
        boolean isWired = false;
        block5: for (BlockFace face : powerSupplyOptions) {
            RedstoneUtil.Power p = RedstoneUtil.isPowered((Block)block, (BlockFace)face);
            switch (p) {
                case ON: {
                    return RedstoneUtil.Power.ON;
                }
                case NA: {
                    continue block5;
                }
                case OFF: {
                    isWired = true;
                }
            }
        }
        return isWired ? RedstoneUtil.Power.OFF : RedstoneUtil.Power.NA;
    }

    public static Minecart getCart(Block rail) {
        for (Entity ent : rail.getChunk().getEntities()) {
            Location entLoc;
            if (!(ent instanceof Minecart) || (entLoc = ent.getLocation()).getBlockX() != rail.getX() || entLoc.getBlockY() != rail.getY() || entLoc.getBlockZ() != rail.getZ()) continue;
            return (Minecart)ent;
        }
        return null;
    }

    public abstract String getName();

    public abstract String[] getApplicableSigns();

    public boolean verify(ChangedSign sign, LocalPlayer player) {
        return true;
    }
}

