/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.cart;

import com.sk89q.craftbook.cart.CartMechanism;
import com.sk89q.craftbook.cart.CartMechanismBlocks;
import com.sk89q.craftbook.cart.CartUtils;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.util.Vector;

public class CartStation
extends CartMechanism {
    public void impact(Minecart cart, CartMechanismBlocks blocks, boolean minor) {
        if (cart == null) {
            return;
        }
        if (!blocks.matches("station")) {
            return;
        }
        switch (this.isActive(blocks.rail, blocks.base, blocks.sign)) {
            case ON: {
                this.launch(cart, blocks.sign);
                break;
            }
            case OFF: 
            case NA: {
                CartUtils.stop(cart);
                Location l = blocks.rail.getLocation().add(0.5, 0.5, 0.5);
                if (cart.getLocation().equals((Object)l)) break;
                cart.teleport(l);
            }
        }
    }

    private void launch(Minecart cart, Block director) {
        cart.setVelocity(CartStation.propel(SignUtil.getFacing((Block)director)));
    }

    public static Vector propel(BlockFace face) {
        return new Vector((double)face.getModX() * 0.2, (double)face.getModY() * 0.2, (double)face.getModZ() * 0.2);
    }

    public void enter(Minecart cart, Entity entity, CartMechanismBlocks blocks, boolean minor) {
        if (cart == null) {
            return;
        }
        if (!blocks.matches("station")) {
            return;
        }
        if (!((Sign)blocks.sign.getState()).getLine(2).equalsIgnoreCase("AUTOSTART")) {
            return;
        }
        switch (this.isActive(blocks.rail, blocks.base, blocks.sign)) {
            case ON: {
                this.launch(cart, blocks.sign);
                break;
            }
            case OFF: 
            case NA: {
                CartUtils.stop(cart);
                Location l = blocks.rail.getLocation().add(0.5, 0.5, 0.5);
                if (cart.getLocation().equals((Object)l)) break;
                cart.teleport(l);
            }
        }
    }

    public String getName() {
        return "Station";
    }

    public String[] getApplicableSigns() {
        return new String[]{"station"};
    }
}

