/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.circuits;

import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.PersistentMechanic;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import java.util.Arrays;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JackOLantern
extends PersistentMechanic {
    CircuitsPlugin plugin;
    BlockWorldVector pt;

    private JackOLantern(CircuitsPlugin plugin, BlockWorldVector pt) {
        this.plugin = plugin;
        this.pt = pt;
    }

    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        this.setPowered(event.getBlock(), event.getNewCurrent() > 0);
        event.getBlock().setData(event.getBlock().getData(), false);
    }

    public void setPowered(Block block, boolean on) {
        byte data = block.getData();
        block.setTypeId(on ? 91 : 86);
        block.setData(data);
    }

    public boolean isActive() {
        return BukkitUtil.toBlock((BlockWorldVector)this.pt).getTypeId() == 91;
    }

    public List<BlockWorldVector> getWatchedPositions() {
        return Arrays.asList(this.pt);
    }

    public void onWatchBlockNotification(BlockEvent evt) {
        if (evt instanceof BlockBreakEvent && evt.getBlock().getTypeId() == 91 && (evt.getBlock().isBlockIndirectlyPowered() || evt.getBlock().isBlockPowered())) {
            ((BlockBreakEvent)evt).setCancelled(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<JackOLantern> {
        CircuitsPlugin plugin;

        public Factory(CircuitsPlugin plugin) {
            this.plugin = plugin;
        }

        public JackOLantern detect(BlockWorldVector pt) {
            int type = BukkitUtil.toWorld((WorldVector)pt).getBlockTypeIdAt(BukkitUtil.toLocation((WorldVector)pt));
            if (type == 86 || type == 91) {
                return new JackOLantern(this.plugin, pt);
            }
            return null;
        }
    }
}

