/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.logic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import org.bukkit.Server;

public class Clock
extends AbstractIC
implements SelfTriggeredIC {
    short tick;
    short reset;

    public Clock(Server server, ChangedSign psign, ICFactory factory) {
        super(server, psign, factory);
    }

    public String getTitle() {
        return "Clock";
    }

    public String getSignTitle() {
        return "CLOCK";
    }

    public void trigger(ChipState chip) {
    }

    protected void triggerClock(ChipState chip) {
        try {
            this.reset = Short.parseShort(this.getSign().getLine(2));
        }
        catch (NumberFormatException e) {
            this.reset = (short)5;
            this.getSign().setLine(2, Short.toString(this.reset));
            this.getSign().update(false);
        }
        try {
            this.tick = Short.parseShort(this.getSign().getLine(3));
        }
        catch (NumberFormatException e) {
            this.tick = 0;
            this.getSign().setLine(3, Short.toString(this.tick));
            this.getSign().update(false);
        }
        this.tick = (short)(this.tick + 1);
        if (this.tick == this.reset) {
            this.tick = 0;
            chip.setOutput(0, !chip.getOutput(0));
        }
        this.getSign().setLine(3, Short.toString(this.tick));
    }

    public boolean isActive() {
        return true;
    }

    public void think(ChipState chip) {
        if (chip.getInput(0)) {
            this.triggerClock(chip);
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new Clock(this.getServer(), sign, this);
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            int interval;
            try {
                interval = Integer.parseInt(sign.getLine(2));
            }
            catch (NumberFormatException e) {
                throw new ICVerificationException("The third line must be a number between 5 and 150.");
            }
            interval = Math.max(interval, 5);
            interval = Math.min(interval, 150);
            sign.setLine(2, Integer.toString(interval));
            sign.setLine(3, "0");
            sign.update(false);
        }

        public String getDescription() {
            return "Outputs high every X ticks when input is high.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"ticks required", "current ticks"};
            return lines;
        }
    }
}

