/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.logic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICVerificationException;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

public class Delayer
extends AbstractIC {
    private int taskId;
    private long delay = 1L;
    private boolean tickDelay;

    public Delayer(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
        try {
            this.delay = Long.parseLong(this.getSign().getLine(2));
            this.tickDelay = Boolean.parseBoolean(this.getSign().getLine(3));
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    public String getTitle() {
        return "Delayer";
    }

    public String getSignTitle() {
        return "DELAYER";
    }

    public void trigger(final ChipState chip) {
        long tdelay = this.delay * 20L;
        if (this.tickDelay) {
            tdelay = this.delay;
        }
        if (chip.getInput(0)) {
            this.taskId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)CircuitsPlugin.getInst(), new Runnable(){

                public void run() {
                    if (chip.getInput(0)) {
                        chip.setOutput(0, true);
                    }
                }
            }, tdelay);
        } else {
            Bukkit.getScheduler().cancelTask(this.taskId);
            chip.setOutput(0, false);
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new Delayer(this.getServer(), sign, this);
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            try {
                Integer.parseInt(sign.getLine(2));
            }
            catch (Exception ignored) {
                throw new ICVerificationException("The third line needs to be a number.");
            }
        }

        public String getDescription() {
            return "Delays signal by X seconds (or ticks if set).";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"seconds", "true to use ticks"};
            return lines;
        }
    }
}

