/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.logic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import org.bukkit.Server;

public class ToggleFlipFlop
extends AbstractIC {
    protected final boolean risingEdge;

    public ToggleFlipFlop(Server server, ChangedSign sign, boolean risingEdge, ICFactory factory) {
        super(server, sign, factory);
        this.risingEdge = risingEdge;
    }

    public String getTitle() {
        return "Toggle Flip Flop";
    }

    public String getSignTitle() {
        return "TOGGLE";
    }

    public void trigger(ChipState chip) {
        if (this.risingEdge && chip.getInput(0) || !this.risingEdge && !chip.getInput(0)) {
            chip.setOutput(0, !chip.getOutput(0));
        }
    }

    public static class Factory
    extends AbstractICFactory {
        protected final boolean risingEdge;

        public Factory(Server server, boolean risingEdge) {
            super(server);
            this.risingEdge = risingEdge;
        }

        public IC create(ChangedSign sign) {
            return new ToggleFlipFlop(this.getServer(), sign, this.risingEdge, this);
        }

        public String getDescription() {
            return "Toggles output on input.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{null, null};
            return lines;
        }
    }
}

