/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.blocks;

import com.sk89q.craftbook.BaseConfiguration;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockWorldVector;
import java.util.HashMap;
import java.util.Random;
import org.bukkit.Server;
import org.bukkit.TreeType;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;

public class BonemealTerraformer
extends AbstractIC {
    int radius;

    public BonemealTerraformer(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    public void load() {
        try {
            this.radius = Integer.parseInt(this.getSign().getLine(2));
            if (this.radius > ((Factory)this.getFactory()).maxradius) {
                this.radius = ((Factory)this.getFactory()).maxradius;
                this.getSign().setLine(3, String.valueOf(((Factory)this.getFactory()).maxradius));
                this.getSign().update(false);
            }
        }
        catch (Exception e) {
            this.radius = 10;
        }
    }

    public String getTitle() {
        return "Bonemeal Terraformer";
    }

    public String getSignTitle() {
        return "TERRAFORMER";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.terraform(true);
        }
    }

    public void terraform(boolean overrideChance) {
        BlockWorldVector position = this.getSign().getBlockVector();
        for (int x = -this.radius + 1; x < this.radius; ++x) {
            for (int y = -this.radius + 1; y < this.radius; ++y) {
                for (int z = -this.radius + 1; z < this.radius; ++z) {
                    if (!overrideChance && BaseBukkitPlugin.random.nextInt(40) != 0) continue;
                    int rx = position.getBlockX() - x;
                    int ry = position.getBlockY() - y;
                    int rz = position.getBlockZ() - z;
                    Block b = BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().getBlockAt(rx, ry, rz);
                    if (b.getTypeId() == 59 && b.getData() < 7) {
                        if (this.consumeBonemeal()) {
                            b.setData((byte)(b.getData() + 1));
                        }
                        return;
                    }
                    if ((b.getTypeId() == 59 || b.getTypeId() == 141 || b.getTypeId() == 142 || b.getTypeId() == 105 || b.getTypeId() == 104) && b.getData() < 7) {
                        if (this.consumeBonemeal()) {
                            b.setData((byte)(b.getData() + 1));
                        }
                        return;
                    }
                    if (b.getTypeId() == 127 && ((b.getData() & 8) != 8 || (b.getData() & 0xC) != 12)) {
                        if (this.consumeBonemeal()) {
                            if (BaseBukkitPlugin.random.nextInt(30) == 0) {
                                b.setData((byte)(b.getData() | 0xC));
                            } else {
                                b.setData((byte)(b.getData() | 8));
                            }
                        }
                        return;
                    }
                    if (b.getTypeId() == 115 && b.getData() < 3) {
                        if (this.consumeBonemeal()) {
                            b.setData((byte)(b.getData() + 1));
                        }
                        return;
                    }
                    if (b.getTypeId() == 6 && this.consumeBonemeal()) {
                        if (!this.growTree(b, BaseBukkitPlugin.random)) {
                            this.refundBonemeal();
                        } else {
                            return;
                        }
                    }
                    if ((b.getTypeId() == 39 || b.getTypeId() == 40) && this.consumeBonemeal()) {
                        if (b.getTypeId() == 39) {
                            b.setTypeId(0);
                            if (!b.getWorld().generateTree(b.getLocation(), TreeType.BROWN_MUSHROOM)) {
                                b.setTypeId(39);
                                this.refundBonemeal();
                            } else {
                                return;
                            }
                        }
                        if (b.getTypeId() == 40) {
                            b.setTypeId(0);
                            if (!b.getWorld().generateTree(b.getLocation(), TreeType.RED_MUSHROOM)) {
                                b.setTypeId(40);
                                this.refundBonemeal();
                            } else {
                                return;
                            }
                        }
                    }
                    if ((b.getTypeId() == 83 || b.getTypeId() == 81) && b.getData() < 21 && b.getRelative(0, 1, 0).getTypeId() == 0) {
                        if (this.consumeBonemeal()) {
                            b.getRelative(0, 1, 0).setTypeId(b.getTypeId());
                        }
                        return;
                    }
                    if (b.getTypeId() == 3 && b.getRelative(0, 1, 0).getTypeId() == 0) {
                        if (this.consumeBonemeal()) {
                            b.setTypeId(b.getBiome() == Biome.MUSHROOM_ISLAND || b.getBiome() == Biome.MUSHROOM_SHORE ? 110 : 2);
                        }
                        return;
                    }
                    if (b.getTypeId() == 2 && b.getRelative(0, 1, 0).getTypeId() == 0 && BaseBukkitPlugin.random.nextInt(15) == 0) {
                        if (this.consumeBonemeal()) {
                            int t = BaseBukkitPlugin.random.nextInt(7);
                            if (t == 0) {
                                b.getRelative(0, 1, 0).setTypeIdAndData(31, (byte)1, true);
                            } else if (t == 1) {
                                b.getRelative(0, 1, 0).setTypeId(37);
                            } else if (t == 2) {
                                b.getRelative(0, 1, 0).setTypeId(38);
                            } else if (t == 3) {
                                b.getRelative(0, 1, 0).setTypeIdAndData(31, (byte)2, true);
                            } else {
                                b.getRelative(0, 1, 0).setTypeIdAndData(31, (byte)1, true);
                            }
                        }
                        return;
                    }
                    if (b.getTypeId() == 12 && b.getRelative(0, 1, 0).getTypeId() == 0 && BaseBukkitPlugin.random.nextInt(15) == 0) {
                        if (this.consumeBonemeal()) {
                            b.getRelative(0, 1, 0).setTypeIdAndData(31, (byte)0, true);
                        }
                        return;
                    }
                    if (b.getTypeId() == 106 && b.getRelative(0, -1, 0).getTypeId() == 0 && BaseBukkitPlugin.random.nextInt(15) == 0) {
                        if (this.consumeBonemeal()) {
                            b.getRelative(0, -1, 0).setTypeIdAndData(106, b.getData(), true);
                        }
                        return;
                    }
                    if (b.getTypeId() == 9 && b.getRelative(0, 1, 0).getTypeId() == 0 && BaseBukkitPlugin.random.nextInt(30) == 0) {
                        if (this.consumeBonemeal()) {
                            b.getRelative(0, 1, 0).setTypeId(111);
                        }
                        return;
                    }
                    if (b.getTypeId() != 110 || b.getRelative(0, 1, 0).getTypeId() != 0 || BaseBukkitPlugin.random.nextInt(15) != 0) continue;
                    if (this.consumeBonemeal()) {
                        int t = BaseBukkitPlugin.random.nextInt(2);
                        if (t == 0) {
                            b.getRelative(0, 1, 0).setTypeId(40);
                        } else if (t == 1) {
                            b.getRelative(0, 1, 0).setTypeId(39);
                        }
                    }
                    return;
                }
            }
        }
    }

    public boolean consumeBonemeal() {
        Block chest = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(0, 1, 0);
        if (chest.getTypeId() == 54) {
            Chest c = (Chest)chest.getState();
            HashMap over = c.getInventory().removeItem(new ItemStack[]{new ItemStack(351, 1, 15)});
            if (over.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public boolean refundBonemeal() {
        Block chest = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(0, 1, 0);
        if (chest.getTypeId() == 54) {
            Chest c = (Chest)chest.getState();
            HashMap over = c.getInventory().addItem(new ItemStack[]{new ItemStack(351, 1, 15)});
            if (over.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public boolean isSameSapling(Block sapling, Block other) {
        return sapling.getTypeId() == other.getTypeId() && (other.getData() & 3) == (sapling.getData() & 3);
    }

    public boolean growTree(Block sapling, Random random) {
        int data = sapling.getData() & 3;
        int i1 = 0;
        int j1 = 0;
        boolean flag = false;
        TreeType treeType = null;
        if (data == 1) {
            treeType = TreeType.REDWOOD;
        } else if (data == 2) {
            treeType = TreeType.BIRCH;
        } else if (data == 3) {
            for (i1 = 0; i1 >= -1; --i1) {
                for (j1 = 0; j1 >= -1; --j1) {
                    if (!this.isSameSapling(sapling, sapling.getRelative(i1, 0, j1)) || !this.isSameSapling(sapling, sapling.getRelative(i1 + 1, 0, j1)) || !this.isSameSapling(sapling, sapling.getRelative(i1, 0, j1 + 1)) || !this.isSameSapling(sapling, sapling.getRelative(i1 + 1, 0, j1 + 1))) continue;
                    treeType = TreeType.JUNGLE;
                    flag = true;
                    break;
                }
                if (flag) break;
            }
            if (!flag) {
                j1 = 0;
                i1 = 0;
                treeType = TreeType.SMALL_JUNGLE;
            }
        } else {
            treeType = TreeType.TREE;
            if (random.nextInt(10) == 0) {
                treeType = TreeType.BIG_TREE;
            }
        }
        if (flag) {
            sapling.getRelative(i1, 0, j1).setTypeId(0);
            sapling.getRelative(i1 + 1, 0, j1).setTypeId(0);
            sapling.getRelative(i1, 0, j1 + 1).setTypeId(0);
            sapling.getRelative(i1 + 1, 0, j1 + 1).setTypeId(0);
        } else {
            sapling.setTypeId(0);
        }
        boolean planted = sapling.getWorld().generateTree(sapling.getRelative(i1, 0, j1).getLocation(), treeType);
        if (!planted) {
            if (flag) {
                sapling.getRelative(i1, 0, j1).setTypeIdAndData(6, (byte)data, true);
                sapling.getRelative(i1 + 1, 0, j1).setTypeIdAndData(6, (byte)data, true);
                sapling.getRelative(i1, 0, j1 + 1).setTypeIdAndData(6, (byte)data, true);
                sapling.getRelative(i1 + 1, 0, j1 + 1).setTypeIdAndData(6, (byte)data, true);
            } else {
                sapling.setTypeIdAndData(6, (byte)data, true);
            }
        }
        return planted;
    }

    public static class Factory
    extends AbstractICFactory {
        int maxradius;

        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new BonemealTerraformer(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Terraforms an area using bonemeal.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"radius", null};
            return lines;
        }

        public void addConfiguration(BaseConfiguration.BaseConfigurationSection section) {
            this.maxradius = section.getInt("max-radius", 15);
        }

        public boolean needsConfiguration() {
            return true;
        }
    }
}

