/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import org.bukkit.Server;
import org.bukkit.block.Block;

public class WaterSensor
extends AbstractIC {
    Block center;

    public WaterSensor(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        this.center = ICUtil.parseBlockLocation(this.getSign());
    }

    public String getTitle() {
        return "Water Sensor";
    }

    public String getSignTitle() {
        return "WATER SENSOR";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.hasWater());
        }
    }

    protected boolean hasWater() {
        int blockID = this.center.getTypeId();
        return blockID == 8 || blockID == 9;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new WaterSensor(this.getServer(), sign, this);
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }

        public String getDescription() {
            return "Outputs high if water is at the given offset.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"x:y:z offset", null};
            return lines;
        }
    }
}

