/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.entity;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Slime;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.material.MaterialData;

public class CreatureSpawner
extends AbstractIC {
    EntityType type;
    String data;
    int amount;

    public CreatureSpawner(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        this.type = EntityType.fromName((String)this.getSign().getLine(2).trim().toLowerCase());
        if (this.type == null) {
            this.type = EntityType.PIG;
        }
        String line = this.getSign().getLine(3).trim();
        try {
            String[] entityInf = RegexUtil.COLON_PATTERN.split(line, 2);
            this.data = entityInf[0];
            this.amount = Integer.parseInt(entityInf[1]);
        }
        catch (Exception e) {
            this.amount = 1;
            this.data = line;
        }
    }

    public String getTitle() {
        return "Creature Spawner";
    }

    public String getSignTitle() {
        return "CREATURE SPAWNER";
    }

    public void trigger(ChipState chip) {
        Block center = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        if (chip.getInput(0)) {
            if (center.getRelative(0, 1, 0).getTypeId() == 52) {
                org.bukkit.block.CreatureSpawner sp = (org.bukkit.block.CreatureSpawner)center.getRelative(0, 1, 0).getState();
                sp.setCreatureTypeByName(this.type.getName());
                sp.update();
            } else {
                Location loc = LocationUtil.getCenterOfBlock((Block)LocationUtil.getNextFreeSpace((Block)center, (BlockFace)BlockFace.UP));
                for (int i = 0; i < this.amount; ++i) {
                    Entity entity = loc.getWorld().spawnEntity(loc, this.type);
                    CreatureSpawner.setEntityData(entity, this.data);
                }
            }
        }
    }

    public static void setEntityData(Entity ent, String bit) {
        String[] data = RegexUtil.COLON_PATTERN.split(bit);
        if (ent instanceof Ageable && data[0].equalsIgnoreCase("baby")) {
            ((Ageable)ent).setBaby();
        }
        if (ent instanceof Tameable && data[0].equalsIgnoreCase("tame")) {
            ((Tameable)ent).setTamed(true);
        }
        if (ent instanceof LivingEntity && data[0].equalsIgnoreCase("stay")) {
            ((LivingEntity)ent).setRemoveWhenFarAway(false);
        }
        if (ent instanceof LivingEntity && data[0].equalsIgnoreCase("despawn")) {
            ((LivingEntity)ent).setRemoveWhenFarAway(true);
        }
        if (ent instanceof LivingEntity && data[0].equalsIgnoreCase("pickup")) {
            ((LivingEntity)ent).setCanPickupItems(true);
        }
        if (ent instanceof Tameable && data[0].equalsIgnoreCase("owner")) {
            ((Tameable)ent).setOwner((AnimalTamer)Bukkit.getPlayer((String)data[1]));
        }
        if (ent instanceof Ageable && data[0].equalsIgnoreCase("babylock")) {
            ((Ageable)ent).setBaby();
            ((Ageable)ent).setAgeLock(true);
        }
        if (ent instanceof LivingEntity && data[0].equalsIgnoreCase("health")) {
            try {
                int health = Integer.parseInt(data[1]);
                ((LivingEntity)ent).setHealth(health);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        switch (ent.getType()) {
            case CREEPER: {
                if (!data[0].equalsIgnoreCase("charged")) break;
                ((Creeper)ent).setPowered(true);
                break;
            }
            case PIG: {
                if (!data[0].equalsIgnoreCase("saddle")) break;
                ((Pig)ent).setSaddle(true);
                break;
            }
            case SLIME: {
                int size;
                if (data[0].equalsIgnoreCase("huge")) {
                    ((Slime)ent).setSize(16);
                    break;
                }
                if (data[0].equalsIgnoreCase("large")) {
                    ((Slime)ent).setSize(11);
                    break;
                }
                if (data[0].equalsIgnoreCase("normal")) {
                    ((Slime)ent).setSize(6);
                    break;
                }
                if (data[0].equalsIgnoreCase("small")) {
                    ((Slime)ent).setSize(3);
                    break;
                }
                if (!data[0].equalsIgnoreCase("size")) break;
                try {
                    size = Integer.parseInt(data[1]);
                    ((Slime)ent).setSize(size);
                }
                catch (Exception ignored) {}
                break;
            }
            case MAGMA_CUBE: {
                int size;
                if (data[0].equalsIgnoreCase("huge")) {
                    ((MagmaCube)ent).setSize(16);
                    break;
                }
                if (data[0].equalsIgnoreCase("large")) {
                    ((MagmaCube)ent).setSize(11);
                    break;
                }
                if (data[0].equalsIgnoreCase("normal")) {
                    ((MagmaCube)ent).setSize(6);
                    break;
                }
                if (data[0].equalsIgnoreCase("small")) {
                    ((MagmaCube)ent).setSize(3);
                    break;
                }
                if (!data[0].equalsIgnoreCase("size")) break;
                try {
                    size = Integer.parseInt(data[1]);
                    ((MagmaCube)ent).setSize(size);
                }
                catch (Exception ignored) {}
                break;
            }
            case WOLF: {
                if (data[0].equalsIgnoreCase("angry")) {
                    ((Wolf)ent).setAngry(true);
                    break;
                }
                if (!data[0].equalsIgnoreCase("collar")) break;
                ((Wolf)ent).setCollarColor(DyeColor.valueOf((String)data[1]));
                break;
            }
            case ENDERMAN: {
                if (!data[0].equalsIgnoreCase("block")) break;
                try {
                    int id = Integer.parseInt(data[1]);
                    byte d = 0;
                    if (data.length > 2) {
                        d = Byte.parseByte(data[2]);
                    }
                    ((Enderman)ent).setCarriedMaterial(new MaterialData(id, d));
                }
                catch (Exception ignored) {}
                break;
            }
            case PRIMED_TNT: {
                if (data[0].equalsIgnoreCase("fuse")) {
                    try {
                        int length = Integer.parseInt(data[1]);
                        ((TNTPrimed)ent).setFuseTicks(length);
                    }
                    catch (Exception ignored) {}
                    break;
                }
                if (data[0].equalsIgnoreCase("yield")) {
                    try {
                        float yield = Float.parseFloat(data[1]);
                        ((TNTPrimed)ent).setYield(yield);
                    }
                    catch (Exception exception) {}
                    break;
                }
                if (!data[0].equalsIgnoreCase("fire")) break;
                ((TNTPrimed)ent).setIsIncendiary(true);
                break;
            }
            case ARROW: {
                if (data[0].equalsIgnoreCase("fire")) {
                    ent.setFireTicks(5000);
                }
                if (!data[0].equalsIgnoreCase("bounce")) break;
                ((Arrow)ent).setBounce(true);
                break;
            }
            case OCELOT: {
                if (data[0].replace("_CAT", "").replace("_OCELOT", "").equalsIgnoreCase("WILD")) {
                    ((Ocelot)ent).setCatType(Ocelot.Type.WILD_OCELOT);
                }
                if (data[0].replace("_CAT", "").replace("_OCELOT", "").equalsIgnoreCase("BLACK")) {
                    ((Ocelot)ent).setCatType(Ocelot.Type.BLACK_CAT);
                }
                if (data[0].replace("_CAT", "").replace("_OCELOT", "").equalsIgnoreCase("RED")) {
                    ((Ocelot)ent).setCatType(Ocelot.Type.RED_CAT);
                }
                if (!data[0].replace("_CAT", "").replace("_OCELOT", "").equalsIgnoreCase("SIAMESE")) break;
                ((Ocelot)ent).setCatType(Ocelot.Type.SIAMESE_CAT);
                break;
            }
            case THROWN_EXP_BOTTLE: {
                if (!data[0].equalsIgnoreCase("bounce")) break;
                ((ThrownExpBottle)ent).setBounce(true);
                break;
            }
            case PIG_ZOMBIE: {
                if (!data[0].equalsIgnoreCase("angry")) break;
                ((PigZombie)ent).setAngry(true);
                break;
            }
            case VILLAGER: {
                if (data[0].equalsIgnoreCase("butcher")) {
                    ((Villager)ent).setProfession(Villager.Profession.BUTCHER);
                    break;
                }
                if (data[0].equalsIgnoreCase("smith")) {
                    ((Villager)ent).setProfession(Villager.Profession.BLACKSMITH);
                    break;
                }
                if (data[0].equalsIgnoreCase("priest")) {
                    ((Villager)ent).setProfession(Villager.Profession.PRIEST);
                    break;
                }
                if (data[0].equalsIgnoreCase("library")) {
                    ((Villager)ent).setProfession(Villager.Profession.LIBRARIAN);
                    break;
                }
                if (!data[0].equalsIgnoreCase("farmer")) break;
                ((Villager)ent).setProfession(Villager.Profession.FARMER);
                break;
            }
            case SHEEP: {
                if (data[0].equalsIgnoreCase("black")) {
                    ((Sheep)ent).setColor(DyeColor.BLACK);
                    break;
                }
                if (data[0].equalsIgnoreCase("red")) {
                    ((Sheep)ent).setColor(DyeColor.RED);
                    break;
                }
                if (data[0].equalsIgnoreCase("green")) {
                    ((Sheep)ent).setColor(DyeColor.GREEN);
                    break;
                }
                if (data[0].equalsIgnoreCase("brown")) {
                    ((Sheep)ent).setColor(DyeColor.BROWN);
                    break;
                }
                if (data[0].equalsIgnoreCase("blue")) {
                    ((Sheep)ent).setColor(DyeColor.BLUE);
                    break;
                }
                if (data[0].equalsIgnoreCase("purple")) {
                    ((Sheep)ent).setColor(DyeColor.PURPLE);
                    break;
                }
                if (data[0].equalsIgnoreCase("cyan")) {
                    ((Sheep)ent).setColor(DyeColor.CYAN);
                    break;
                }
                if (data[0].equalsIgnoreCase("silver")) {
                    ((Sheep)ent).setColor(DyeColor.SILVER);
                    break;
                }
                if (data[0].equalsIgnoreCase("gray")) {
                    ((Sheep)ent).setColor(DyeColor.GRAY);
                    break;
                }
                if (data[0].equalsIgnoreCase("pink")) {
                    ((Sheep)ent).setColor(DyeColor.PINK);
                    break;
                }
                if (data[0].equalsIgnoreCase("lime")) {
                    ((Sheep)ent).setColor(DyeColor.LIME);
                    break;
                }
                if (data[0].equalsIgnoreCase("yellow")) {
                    ((Sheep)ent).setColor(DyeColor.YELLOW);
                    break;
                }
                if (data[0].equalsIgnoreCase("lblue")) {
                    ((Sheep)ent).setColor(DyeColor.LIGHT_BLUE);
                    break;
                }
                if (data[0].equalsIgnoreCase("magenta")) {
                    ((Sheep)ent).setColor(DyeColor.MAGENTA);
                    break;
                }
                if (data[0].equalsIgnoreCase("orange")) {
                    ((Sheep)ent).setColor(DyeColor.ORANGE);
                    break;
                }
                if (!data[0].equalsIgnoreCase("white")) break;
                ((Sheep)ent).setColor(DyeColor.WHITE);
                break;
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new CreatureSpawner(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Spawns a mob with specified data.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"entitytype", "data:amount"};
            return lines;
        }
    }
}

