/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.entity;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.EnumUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.RegexUtil;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.PoweredMinecart;
import org.bukkit.entity.StorageMinecart;

public class EntityTrap
extends AbstractIC {
    int radius;
    int damage;
    Type type;
    Location location;

    public EntityTrap(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Entity Trap";
    }

    public String getSignTitle() {
        return "ENTITY TRAP";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.hurt());
        }
    }

    public void load() {
        this.location = BukkitUtil.toSign((ChangedSign)this.getSign()).getLocation();
        try {
            String[] splitLine = RegexUtil.EQUALS_PATTERN.split(this.getSign().getLine(2), 3);
            this.radius = Integer.parseInt(splitLine[0]);
            if (this.getSign().getLine(2).contains("=")) {
                String[] pos = RegexUtil.COLON_PATTERN.split(splitLine[1]);
                int x = Integer.parseInt(pos[0]);
                int y = Integer.parseInt(pos[1]);
                int z = Integer.parseInt(pos[2]);
                this.location.add((double)x, (double)y, (double)z);
                this.damage = Integer.parseInt(splitLine[2]);
            } else {
                this.damage = 2;
            }
        }
        catch (Exception ignored) {
            this.radius = 10;
            this.damage = 2;
        }
        this.type = !this.getSign().getLine(3).isEmpty() ? Type.fromString(this.getSign().getLine(3)) : Type.MOB_HOSTILE;
    }

    protected boolean hurt() {
        boolean hasHurt = false;
        for (Entity e : LocationUtil.getNearbyEntities((Location)this.location, (int)this.radius)) {
            if (e == null || e.isDead() || !e.isValid() || !this.type.is(e)) continue;
            if (e instanceof LivingEntity) {
                ((LivingEntity)e).damage(this.damage);
            } else if (e instanceof Minecart) {
                ((Minecart)e).setDamage(((Minecart)e).getDamage() + this.damage);
            } else {
                e.remove();
            }
            hasHurt = true;
        }
        return hasHurt;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new EntityTrap(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Damage nearby entities of type.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"radius=x:y:z=damage", "mob type"};
            return lines;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        PLAYER,
        MOB_HOSTILE,
        MOB_PEACEFUL,
        MOB_ANY,
        ANY,
        CART,
        CART_STORAGE,
        CART_POWERED,
        ITEM;


        public boolean is(Entity entity) {
            switch (this) {
                case PLAYER: {
                    return entity instanceof Player;
                }
                case MOB_HOSTILE: {
                    return entity instanceof Monster;
                }
                case MOB_PEACEFUL: {
                    return entity instanceof Animals;
                }
                case MOB_ANY: {
                    return entity instanceof Creature;
                }
                case CART: {
                    return entity instanceof Minecart;
                }
                case CART_STORAGE: {
                    return entity instanceof StorageMinecart;
                }
                case CART_POWERED: {
                    return entity instanceof PoweredMinecart;
                }
                case ITEM: {
                    return entity instanceof Item;
                }
                case ANY: {
                    return true;
                }
            }
            return false;
        }

        public static Type fromString(String name) {
            return (Type)EnumUtil.getEnumFromString(Type.class, (String)name);
        }
    }
}

