/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.items;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.SignUtil;
import java.util.HashMap;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BrewingStand;
import org.bukkit.block.Chest;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Furnace;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ContainerDispenser
extends AbstractIC {
    int amount;

    public ContainerDispenser(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        try {
            this.amount = Integer.parseInt(this.getSign().getLine(2));
        }
        catch (Exception e) {
            this.amount = 1;
        }
    }

    public String getTitle() {
        return "Container Dispenser";
    }

    public String getSignTitle() {
        return "CONTAINER DISPENSER";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.dispense());
        }
    }

    protected boolean dispense() {
        FurnaceInventory inv;
        ItemStack stack;
        block4: {
            Block bl;
            block6: {
                block5: {
                    block3: {
                        Block b = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
                        int x = b.getX();
                        int y = b.getY() + 1;
                        int z = b.getZ();
                        bl = BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock().getWorld().getBlockAt(x, y, z);
                        stack = null;
                        inv = null;
                        if (bl.getTypeId() != 54) break block3;
                        Chest c = (Chest)bl.getState();
                        for (ItemStack it : c.getInventory().getContents()) {
                            if (!ItemUtil.isStackValid((ItemStack)it)) continue;
                            stack = it;
                            inv = c.getInventory();
                        }
                        break block4;
                    }
                    if (bl.getTypeId() != 61 && bl.getTypeId() != 62) break block5;
                    Furnace c = (Furnace)bl.getState();
                    stack = c.getInventory().getResult();
                    inv = c.getInventory();
                    break block4;
                }
                if (bl.getTypeId() != 117) break block6;
                BrewingStand c = (BrewingStand)bl.getState();
                for (ItemStack it : c.getInventory().getContents()) {
                    if (!ItemUtil.isStackValid((ItemStack)it) || ItemUtil.areItemsIdentical((ItemStack)it, (ItemStack)c.getInventory().getIngredient())) continue;
                    stack = it;
                    inv = c.getInventory();
                }
                break block4;
            }
            if (bl.getTypeId() != 23) break block4;
            Dispenser c = (Dispenser)bl.getState();
            for (ItemStack it : c.getInventory().getContents()) {
                if (!ItemUtil.isStackValid((ItemStack)it)) continue;
                stack = it;
                inv = c.getInventory();
            }
        }
        return stack != null && inv != null && this.dispenseItem((Inventory)inv, stack);
    }

    public boolean dispenseItem(Inventory inv, ItemStack item) {
        if (inv == null) {
            return false;
        }
        HashMap over = inv.removeItem(new ItemStack[]{new ItemStack(item.getTypeId(), this.amount, item.getDurability())});
        if (over.isEmpty()) {
            BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().dropItemNaturally(BukkitUtil.toSign((ChangedSign)this.getSign()).getLocation(), new ItemStack(item.getTypeId(), this.amount, item.getDurability()));
            return true;
        }
        for (ItemStack it : over.values()) {
            if (this.amount - it.getAmount() < 1) continue;
            BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().dropItemNaturally(BukkitUtil.toSign((ChangedSign)this.getSign()).getLocation(), new ItemStack(it.getTypeId(), this.amount - it.getAmount(), it.getDurability()));
            return true;
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new ContainerDispenser(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Dispenses items out of containers.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"amount to remove", null};
            return lines;
        }
    }
}

