/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.items;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class ItemFan
extends AbstractIC {
    double force;

    public ItemFan(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        try {
            this.force = Double.parseDouble(this.getSign().getLine(2));
        }
        catch (Exception ignored) {
            this.force = 1.0;
        }
    }

    public String getTitle() {
        return "Item Fan";
    }

    public String getSignTitle() {
        return "ITEM FAN";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.push());
        }
    }

    public boolean push() {
        boolean returnValue = false;
        Block aboveBlock = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(0, 1, 0);
        for (Entity en : aboveBlock.getChunk().getEntities()) {
            Item item;
            ItemStack stack;
            if (!(en instanceof Item) || !ItemUtil.isStackValid((ItemStack)(stack = (item = (Item)en).getItemStack())) || item.isDead() || !item.isValid()) continue;
            Location location = item.getLocation();
            int ix = location.getBlockX();
            int iy = location.getBlockY();
            int iz = location.getBlockZ();
            if (ix != aboveBlock.getX() || iy != aboveBlock.getY() || iz != aboveBlock.getZ()) continue;
            item.teleport(item.getLocation().add(0.0, this.force, 0.0));
            returnValue = true;
        }
        return returnValue;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new ItemFan(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Gently pushes items upwards.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"force (default 1)", null};
            return lines;
        }
    }
}

