/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.BlockUtil;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TNTPrimed;

public class TimedExplosion
extends AbstractIC {
    private int ticks;
    private float yield;
    private boolean flamey;
    Block signBlock;
    Block infront;

    public TimedExplosion(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    public void load() {
        try {
            this.ticks = Integer.parseInt(this.getSign().getLine(2));
        }
        catch (Exception e) {
            this.ticks = -1;
        }
        try {
            this.yield = Float.parseFloat(this.getSign().getLine(3).replace("!", ""));
        }
        catch (Exception e) {
            this.yield = -1.0f;
        }
        try {
            this.flamey = this.getSign().getLine(3).endsWith("!");
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            this.signBlock = BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock();
            this.infront = this.signBlock.getRelative(SignUtil.getBack((Block)this.signBlock).getOppositeFace());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTitle() {
        return "Timed Explosive";
    }

    public String getSignTitle() {
        return "TIME BOMB";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            TNTPrimed tnt = (TNTPrimed)this.signBlock.getWorld().spawnEntity(BlockUtil.getBlockCentre((Block)this.infront), EntityType.PRIMED_TNT);
            tnt.setIsIncendiary(this.flamey);
            if (this.ticks > 0) {
                tnt.setFuseTicks(this.ticks);
            }
            if (this.yield > 0.0f) {
                tnt.setYield(this.yield);
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new TimedExplosion(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Spawn tnt with custom fuse and yield.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"time in ticks", "explosion radius (ending with ! makes fire)"};
            return lines;
        }
    }
}

