/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.jinglenote.JingleNoteManager;
import com.sk89q.craftbook.jinglenote.StringJingleSequencer;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.RegexUtil;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class Tune
extends AbstractIC {
    StringJingleSequencer sequencer;
    JingleNoteManager jNote = new JingleNoteManager();
    int radius;
    int delay;
    String tune;

    public Tune(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Tune Player";
    }

    public String getSignTitle() {
        return "TUNE";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            if (this.sequencer != null || this.jNote != null) {
                for (Player player : this.getServer().getOnlinePlayers()) {
                    this.jNote.stop(player);
                }
                this.jNote.stopAll();
            }
            this.sequencer = new StringJingleSequencer(this.tune, this.delay);
            for (Player player : this.getServer().getOnlinePlayers()) {
                if (player == null || this.radius > 0 && !LocationUtil.isWithinRadius((Location)BukkitUtil.toSign((ChangedSign)this.getSign()).getLocation(), (Location)player.getLocation(), (int)this.radius)) continue;
                this.jNote.play(player, this.sequencer);
            }
        } else if (!chip.getInput(0) && this.sequencer != null) {
            this.sequencer.stop();
            for (Player player : this.getServer().getOnlinePlayers()) {
                this.jNote.stop(player);
            }
            this.jNote.stopAll();
        }
    }

    public void load() {
        try {
            this.radius = Integer.parseInt(this.getSign().getLine(3));
        }
        catch (Exception ignored) {
            this.radius = -1;
        }
        if (this.getLine(2).contains(":")) {
            String[] split = RegexUtil.COLON_PATTERN.split(this.getLine(2), 2);
            try {
                this.delay = Integer.parseInt(split[0]);
            }
            catch (Exception e) {
                this.delay = 2;
            }
            this.tune = split[1];
        } else {
            this.tune = this.getSign().getLine(2);
            this.delay = 2;
        }
    }

    public void unload() {
        try {
            this.sequencer.stop();
            for (Player player : this.getServer().getOnlinePlayers()) {
                this.jNote.stop(player);
            }
            this.jNote.stopAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public String getDescription() {
            return "Plays a tune.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"Delay:Tune", "Radius"};
            return lines;
        }

        public IC create(ChangedSign sign) {
            return new Tune(this.getServer(), sign, this);
        }
    }
}

