/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.util.EnumUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.PoweredMinecart;
import org.bukkit.entity.StorageMinecart;

public class EntitySensor
extends AbstractIC {
    private Set<Type> types;
    private Block center;
    private Set<Chunk> chunks;
    private int radius;

    public EntitySensor(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    public void load() {
        this.getSign().setLine(3, this.getSign().getLine(3).toUpperCase());
        this.types = Type.getDetected(this.getSign().getLine(3).trim());
        this.radius = ICUtil.parseRadius(this.getSign());
        if (this.getSign().getLine(2).contains("=")) {
            this.getSign().setLine(2, this.radius + 61 + RegexUtil.EQUALS_PATTERN.split(this.getSign().getLine(2))[1]);
            this.center = ICUtil.parseBlockLocation(this.getSign());
        } else {
            this.getSign().setLine(2, String.valueOf(this.radius));
            this.center = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        }
        this.getSign().update(false);
    }

    public String getTitle() {
        return "Entity Sensor";
    }

    public String getSignTitle() {
        return "ENTITY SENSOR";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.isDetected());
        }
    }

    protected boolean isDetected() {
        this.chunks = LocationUtil.getSurroundingChunks((Block)SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()), (int)this.radius);
        for (Chunk chunk : this.chunks) {
            if (!chunk.isLoaded()) continue;
            block1: for (Entity entity : chunk.getEntities()) {
                if (!entity.isValid()) continue;
                for (Type type : this.types) {
                    if (!type.is(entity)) continue;
                    if (!LocationUtil.isWithinRadius((Location)this.center.getLocation(), (Location)entity.getLocation(), (int)this.radius)) continue block1;
                    return true;
                }
            }
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new EntitySensor(this.getServer(), sign, this);
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }

        public String getDescription() {
            return "Detects specific entity types in a given radius.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"radius=x:y:z offset", "Entity Types"};
            return lines;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PLAYER('P'),
        ITEM('I'),
        MOB_HOSTILE('H'),
        MOB_PEACEFUL('A'),
        MOB_ANY('M'),
        ANY('L'),
        CART('C'),
        CART_STORAGE('S'),
        CART_POWERED('E');

        private final char shortName;

        public boolean is(Entity entity) {
            switch (this) {
                case PLAYER: {
                    return entity instanceof Player;
                }
                case ITEM: {
                    return entity instanceof Item;
                }
                case MOB_HOSTILE: {
                    return entity instanceof Monster && !(entity instanceof Player);
                }
                case MOB_PEACEFUL: {
                    return entity instanceof Animals;
                }
                case MOB_ANY: {
                    return entity instanceof Creature;
                }
                case CART: {
                    return entity instanceof Minecart;
                }
                case CART_STORAGE: {
                    return entity instanceof StorageMinecart;
                }
                case CART_POWERED: {
                    return entity instanceof PoweredMinecart;
                }
                case ANY: {
                    return true;
                }
            }
            return false;
        }

        private Type(char shortName) {
            this.shortName = shortName;
        }

        public char getCharName() {
            return this.shortName;
        }

        public static Set<Type> getDetected(String line) {
            EnumSet<Type> types = EnumSet.noneOf(Type.class);
            if (line.trim().isEmpty()) {
                types.add(ANY);
                return types;
            }
            Type type = (Type)EnumUtil.getEnumFromString(Type.class, (String)line);
            if (type != null) {
                types.add(type);
            } else {
                for (char aChar : line.toCharArray()) {
                    for (Type aType : Type.values()) {
                        if (aType.getCharName() != aChar) continue;
                        types.add(aType);
                    }
                }
            }
            if (types.isEmpty()) {
                types.add(ANY);
            }
            return types;
        }
    }
}

