/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.gates.world.sensors.PowerSensor;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import org.bukkit.Server;

public class PowerSensorST
extends PowerSensor
implements SelfTriggeredIC {
    public PowerSensorST(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    public String getTitle() {
        return "Self Triggered Power Sensor";
    }

    public String getSignTitle() {
        return "ST POWER SENSOR";
    }

    public void think(ChipState state) {
        state.setOutput(0, this.isPowered());
    }

    public boolean isActive() {
        return true;
    }

    public static class Factory
    extends PowerSensor.Factory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            try {
                if (sign.getLine(1).equalsIgnoreCase("[MC0270]")) {
                    sign.setLine(1, "[MC0266]");
                    sign.update(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new PowerSensorST(this.getServer(), sign, this);
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }
    }
}

