/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.ic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockWorldVector;
import org.bukkit.block.Block;

public abstract class AbstractChipState
implements ChipState {
    protected final ChangedSign sign;
    protected final BlockWorldVector source;
    protected final boolean selfTriggered;
    protected final Block icBlock;

    protected AbstractChipState(BlockWorldVector source, ChangedSign sign, boolean selfTriggered) {
        this.sign = sign;
        this.source = source;
        this.selfTriggered = selfTriggered;
        this.icBlock = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)sign).getBlock());
    }

    protected abstract Block getBlock(int var1);

    public boolean get(int pin) {
        Block block = this.getBlock(pin);
        return block != null && block.isBlockIndirectlyPowered();
    }

    public void set(int pin, boolean value) {
        Block block = this.getBlock(pin);
        if (block != null) {
            ICUtil.setState(block, value, this.icBlock);
        }
    }

    public boolean isTriggered(int pin) {
        Block block = this.getBlock(pin);
        return block != null && BukkitUtil.toWorldVector((Block)block).equals((Object)this.source);
    }

    public boolean isValid(int pin) {
        Block block = this.getBlock(pin);
        if (block != null) {
            if (block.getTypeId() == 55) {
                return true;
            }
            if (block.getTypeId() == 93 || block.getTypeId() == 94) {
                return true;
            }
        }
        return false;
    }
}

