/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseConfiguration {
    public final FileConfiguration cfg;
    public final File dataFolder;

    public BaseConfiguration(FileConfiguration cfg, File dataFolder) {
        this.cfg = cfg;
        this.dataFolder = dataFolder;
        this.load();
    }

    public abstract void load();

    public int getInt(String name, int def) {
        int it = this.cfg.getInt(name, def);
        this.cfg.set(name, (Object)it);
        return it;
    }

    public double getDouble(String name, double def) {
        double it = this.cfg.getDouble(name, def);
        this.cfg.set(name, (Object)it);
        return it;
    }

    public boolean getBoolean(String name, boolean def) {
        boolean it = this.cfg.getBoolean(name, def);
        this.cfg.set(name, (Object)it);
        return it;
    }

    public String getString(String name, String def) {
        String it = this.cfg.getString(name, def);
        this.cfg.set(name, (Object)it);
        return it;
    }

    public List<String> getStringList(String name, List<String> def) {
        List<String> it = this.cfg.getStringList(name);
        if (it == null || it.isEmpty()) {
            it = def;
        }
        this.cfg.set(name, it);
        return it;
    }

    public Set<Integer> getIntegerSet(String name, List<Integer> def) {
        List<Integer> tids = this.cfg.getIntegerList(name);
        if (tids == null || tids.isEmpty() || tids.size() < 1) {
            tids = def;
        }
        HashSet<Integer> allowedBlocks = new HashSet<Integer>();
        for (Integer tid : tids) {
            allowedBlocks.add(tid);
        }
        this.cfg.set(name, tids);
        return allowedBlocks;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BaseConfigurationSection {
        public final ConfigurationSection section;

        public BaseConfigurationSection(String section) {
            if (!BaseConfiguration.this.cfg.isConfigurationSection(section)) {
                BaseConfiguration.this.cfg.createSection(section);
            }
            this.section = BaseConfiguration.this.cfg.getConfigurationSection(section);
        }

        public int getInt(String name, int def) {
            int it = this.section.getInt(name, def);
            this.section.set(name, (Object)it);
            return it;
        }

        public double getDouble(String name, double def) {
            double it = this.section.getDouble(name, def);
            this.section.set(name, (Object)it);
            return it;
        }

        public boolean getBoolean(String name, boolean def) {
            boolean it = this.section.getBoolean(name, def);
            this.section.set(name, (Object)it);
            return it;
        }

        public String getString(String name, String def) {
            String it = this.section.getString(name, def);
            this.section.set(name, (Object)it);
            return it;
        }

        public List<String> getStringList(String name, List<String> def) {
            List<String> it = this.section.getStringList(name);
            if (it == null || it.isEmpty()) {
                it = def;
            }
            this.section.set(name, it);
            return it;
        }

        public Set<Integer> getIntegerSet(String name, List<Integer> def) {
            List<Integer> tids = this.section.getIntegerList(name);
            if (tids == null || tids.isEmpty() || tids.size() < 1) {
                tids = def;
            }
            HashSet<Integer> allowedBlocks = new HashSet<Integer>();
            for (Integer tid : tids) {
                allowedBlocks.add(tid);
            }
            this.section.set(name, tids);
            return allowedBlocks;
        }
    }
}

