/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.blockbag;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.blockbag.BlockBagFactory;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.bags.BlockBagException;
import com.sk89q.worldedit.bags.OutOfBlocksException;
import com.sk89q.worldedit.bags.OutOfSpaceException;
import org.bukkit.World;
import org.bukkit.block.Block;

public class AdminBlockSource
extends BlockBag {
    private boolean fetch = true;
    private boolean store = true;
    private boolean canFetch = false;
    private boolean canStore = false;

    public AdminBlockSource() {
    }

    public AdminBlockSource(boolean fetch, boolean store) {
        this.fetch = fetch;
        this.store = store;
    }

    public void fetchBlock(int id) throws BlockBagException {
        if (!this.canFetch) {
            throw new OutOfBlocksException();
        }
    }

    public void storeBlock(int id) throws BlockBagException {
        if (!this.canStore) {
            throw new OutOfSpaceException(id);
        }
    }

    public void addSourcePosition(WorldVector arg0) {
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    this.addSingleSourcePosition(new WorldVector(arg0.getWorld(), arg0.add(x, y, z)));
                }
            }
        }
    }

    public void addSingleSourcePosition(WorldVector arg0) {
        Block e = BukkitUtil.toWorld(arg0.getWorld()).getBlockAt(arg0.getBlockX(), arg0.getBlockY(), arg0.getBlockZ());
        if (e.getTypeId() == 68 || e.getTypeId() == 63) {
            ChangedSign s = BukkitUtil.toChangedSign(e);
            if (this.store && s.getLine(2).equalsIgnoreCase("[Black Hole]")) {
                this.canStore = true;
            }
            if (this.fetch && s.getLine(2).equalsIgnoreCase("[Block Source]")) {
                this.canFetch = true;
            }
        }
    }

    public void flushChanges() {
    }

    public static class UnlimitedSourceFactory
    implements BlockBagFactory {
        public BlockBag createBlockSource(World w, Vector v) {
            return new AdminBlockSource(true, false);
        }
    }

    public static class BlackHoleFactory
    implements BlockBagFactory {
        public BlockBag createBlockSource(World w, Vector v) {
            return new AdminBlockSource(false, true);
        }
    }
}

