/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.blockbag;

import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.bags.BlockBagException;
import com.sk89q.worldedit.bags.OutOfBlocksException;
import com.sk89q.worldedit.bags.OutOfSpaceException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundBlockBag
extends BlockBag {
    private final List<BlockBag> sources;

    public CompoundBlockBag(List<BlockBag> bags) {
        this.sources = bags;
    }

    public void storeBlock(int id) throws BlockBagException {
        for (BlockBag b : this.sources) {
            try {
                b.storeBlock(id);
                return;
            }
            catch (OutOfSpaceException ignored) {
            }
        }
        throw new OutOfSpaceException(id);
    }

    public void fetchBlock(int id) throws BlockBagException {
        for (BlockBag b : this.sources) {
            try {
                b.fetchBlock(id);
                return;
            }
            catch (OutOfBlocksException ignored) {
            }
        }
        throw new OutOfBlocksException();
    }

    public void flushChanges() {
        for (BlockBag b : this.sources) {
            b.flushChanges();
        }
    }

    public void addSingleSourcePosition(WorldVector arg0) {
        for (BlockBag b : this.sources) {
            b.addSingleSourcePosition(arg0);
        }
    }

    public void addSourcePosition(WorldVector arg0) {
        for (BlockBag b : this.sources) {
            b.addSourcePosition(arg0);
        }
    }
}

