/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.blockbag;

import com.sk89q.craftbook.blockbag.BlockBagFactory;
import com.sk89q.craftbook.util.DistanceComparator;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.bags.BlockBagException;
import com.sk89q.worldedit.bags.OutOfBlocksException;
import com.sk89q.worldedit.bags.OutOfSpaceException;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import java.util.Set;
import java.util.TreeSet;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;

public class NearbyChestBlockBag
extends BlockBag {
    private final Set<Chest> chests;

    public NearbyChestBlockBag(Vector origin) {
        DistanceComparator comparator = new DistanceComparator(origin);
        this.chests = new TreeSet<BlockState>(comparator);
    }

    public void fetchBlock(int id) throws BlockBagException {
        try {
            for (Chest chest : this.chests) {
                ItemStack[] itemArray = chest.getInventory().getContents();
                for (int i = 0; itemArray.length > i; ++i) {
                    if (itemArray[i] == null || itemArray[i].getTypeId() != id || itemArray[i].getAmount() < 1) continue;
                    int newAmount = itemArray[i].getAmount() - 1;
                    itemArray[i] = newAmount > 0 ? new ItemStack(itemArray[i].getTypeId(), newAmount) : null;
                    chest.getInventory().setContents(itemArray);
                    return;
                }
            }
            throw new OutOfBlocksException();
        }
        finally {
            this.flushChanges();
        }
    }

    public void storeBlock(int id) throws BlockBagException {
        try {
            for (Chest chest : this.chests) {
                ItemStack[] itemArray = chest.getInventory().getContents();
                int emptySlot = -1;
                int i = 0;
                while (itemArray.length > i) {
                    if (itemArray[i].getTypeId() == id && itemArray[i].getAmount() < 64) {
                        int newAmount = itemArray[i].getAmount() + 1;
                        itemArray[i] = new ItemStack(itemArray[i].getTypeId(), newAmount);
                        chest.getInventory().setContents(itemArray);
                        return;
                    }
                    emptySlot = i++;
                }
                if (emptySlot == -1) continue;
                itemArray[emptySlot] = new ItemStack(id, 1);
                chest.getInventory().setContents(itemArray);
                return;
            }
            throw new OutOfSpaceException(id);
        }
        finally {
            this.flushChanges();
        }
    }

    public void storeBlock(int id, int amount) throws BlockBagException {
    }

    public void addSourcePosition(WorldVector arg0) {
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    Vector cur = arg0.add(x, y, z);
                    this.addSingleSourcePosition(new WorldVector(arg0.getWorld(), cur));
                }
            }
        }
    }

    public void addSingleSourcePosition(WorldVector arg0) {
        Chest chest;
        BlockState complexBlock;
        int x = arg0.getBlockX();
        int y = arg0.getBlockY();
        int z = arg0.getBlockZ();
        if (BukkitUtil.toWorld((LocalWorld)arg0.getWorld()).getBlockAt(BukkitUtil.toLocation((WorldVector)arg0)).getTypeId() == BlockType.CHEST.getID() && (complexBlock = BukkitUtil.toWorld((LocalWorld)arg0.getWorld()).getBlockAt(x, y, z).getState()) instanceof Chest && !this.chests.contains(chest = (Chest)complexBlock)) {
            this.chests.add((Chest)complexBlock);
        }
    }

    public int getChestBlockCount() {
        return this.chests.size();
    }

    public Chest[] getInventories() {
        return this.chests.toArray(new Chest[this.chests.size()]);
    }

    public void flushChanges() {
    }

    public static class Factory
    implements BlockBagFactory {
        public BlockBag createBlockSource(World world, Vector v) {
            return new NearbyChestBlockBag(v);
        }
    }
}

