/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util;

import org.bukkit.entity.Item;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class ItemUtil {
    private ItemUtil() {
    }

    public static boolean areItemsSimilar(ItemStack item, int type) {
        return ItemUtil.areItemsSimilar(item, new MaterialData(type, 0));
    }

    public static boolean areItemsSimilar(ItemStack item, MaterialData data) {
        return ItemUtil.areItemsSimilar(item.getData(), data);
    }

    public static boolean areItemsSimilar(ItemStack item, ItemStack item2) {
        return ItemUtil.areItemsSimilar(item.getData(), item2.getData());
    }

    public static boolean areItemsSimilar(MaterialData data, MaterialData comparedData) {
        return data.getItemTypeId() == comparedData.getItemTypeId();
    }

    public static boolean areItemsIdentical(ItemStack item, int type, byte data) {
        return ItemUtil.areItemsIdentical(item, new MaterialData(type, data));
    }

    public static boolean areItemsIdentical(ItemStack item, MaterialData data) {
        return ItemUtil.areItemsIdentical(item.getData(), data);
    }

    public static boolean areItemsIdentical(ItemStack item, ItemStack item2) {
        return !ItemUtil.isStackValid(item) && !ItemUtil.isStackValid(item2) || ItemUtil.areItemsIdentical(item.getData(), item2.getData());
    }

    public static boolean areItemsIdentical(MaterialData data, MaterialData comparedData) {
        return data.getItemTypeId() == comparedData.getItemTypeId() && data.getData() == data.getData();
    }

    public static void setItemTypeAndData(ItemStack item, int type, byte data) {
        item.setData(new MaterialData(type, data));
    }

    public static boolean isStackValid(ItemStack item) {
        return item != null && item.getAmount() > 0 && item.getTypeId() > 0;
    }

    public static boolean takeFromEntity(Item item) {
        if (item == null || item.isDead()) {
            return false;
        }
        if (!ItemUtil.isStackValid(item.getItemStack())) {
            item.remove();
            return false;
        }
        item.getItemStack().setAmount(item.getItemStack().getAmount() - 1);
        if (!ItemUtil.isStackValid(item.getItemStack())) {
            item.remove();
        }
        return true;
    }

    public static boolean isCookable(ItemStack item) {
        return ItemUtil.getCookedResult(item) != null;
    }

    public static ItemStack getCookedResult(ItemStack item) {
        switch (item.getTypeId()) {
            case 363: {
                return new ItemStack(364);
            }
            case 365: {
                return new ItemStack(366);
            }
            case 349: {
                return new ItemStack(350);
            }
            case 319: {
                return new ItemStack(320);
            }
            case 392: {
                return new ItemStack(393);
            }
        }
        return null;
    }

    public static boolean isSmeltable(ItemStack item) {
        return ItemUtil.getSmeletedResult(item) != null;
    }

    public static ItemStack getSmeletedResult(ItemStack item) {
        switch (item.getTypeId()) {
            case 4: {
                return new ItemStack(1);
            }
            case 81: {
                return new ItemStack(351, 1, 2);
            }
            case 17: {
                return new ItemStack(263, 1, 1);
            }
            case 15: {
                return new ItemStack(265);
            }
            case 73: {
                return new ItemStack(331);
            }
            case 129: {
                return new ItemStack(388);
            }
            case 14: {
                return new ItemStack(266);
            }
            case 56: {
                return new ItemStack(264);
            }
            case 12: {
                return new ItemStack(20);
            }
            case 337: {
                return new ItemStack(336);
            }
        }
        return null;
    }

    public static boolean isAFuel(ItemStack item) {
        int i = item.getTypeId();
        return i == 263 || i == 17 || i == 5 || i == 126 || i == 6 || i == 271 || i == 290 || i == 270 || i == 269 || i == 268 || i == 72 || i == 280 || i == 85 || i == 53 || i == 96 || i == 58 || i == 54 || i == 84 || i == 25 || i == 99 || i == 100 || i == 369 || i == 327;
    }

    public static boolean isAPotionIngredient(ItemStack item) {
        int i = item.getTypeId();
        return i == 372 || i == 348 || i == 331 || i == 375 || i == 378 || i == 353 || i == 382 || i == 370 || i == 377 || i == 376 || i == 289;
    }

    public static void addToStack(ItemStack stack, ItemStack to) {
        if (stack == null) {
            stack = new ItemStack(to.getTypeId(), to.getAmount(), to.getDurability());
        } else if (ItemUtil.areItemsIdentical(stack, to)) {
            stack.setAmount(stack.getAmount() + to.getAmount());
        }
    }

    public static boolean containsRawFood(Inventory inv) {
        for (ItemStack it : inv.getContents()) {
            if (it == null || !ItemUtil.isCookable(it)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsRawMinerals(Inventory inv) {
        for (ItemStack it : inv.getContents()) {
            if (it == null || !ItemUtil.isSmeltable(it)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFurnacable(ItemStack item) {
        return ItemUtil.isCookable(item) || ItemUtil.isSmeltable(item);
    }

    public static boolean isItemEdible(ItemStack item) {
        return item.getType().isEdible();
    }

    public static ItemStack getUsedItem(ItemStack item) {
        if (item.getTypeId() == 282) {
            item.setTypeId(281);
        } else if (item.getTypeId() == 373) {
            item.setTypeId(374);
        } else if (item.getTypeId() == 327 || item.getTypeId() == 326 || item.getTypeId() == 335) {
            item.setTypeId(325);
        } else if (item.getAmount() == 1) {
            item.setTypeId(0);
        } else {
            item.setAmount(item.getAmount() - 1);
        }
        return item;
    }

    public static ItemStack getSmallestStackOfType(ItemStack[] stacks, ItemStack item) {
        ItemStack smallest = null;
        for (ItemStack it : stacks) {
            if (!ItemUtil.isStackValid(it) || !ItemUtil.areItemsIdentical(it, item)) continue;
            if (smallest == null) {
                smallest = it;
            }
            if (it.getAmount() >= smallest.getAmount()) continue;
            smallest = it;
        }
        return smallest;
    }
}

