/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class HiddenSwitch
extends AbstractMechanic {
    final Block switchBlock;
    final MechanismsPlugin plugin;

    public HiddenSwitch(Block block, MechanismsPlugin plugin) {
        this.switchBlock = block;
        this.plugin = plugin;
    }

    public void onRightClick(PlayerInteractEvent event) {
        LocalPlayer player = this.plugin.wrap(event.getPlayer());
        try {
            player.checkPermission("craftbook.mech.hiddenswitch.use");
        }
        catch (InsufficientPermissionsException e) {
            return;
        }
        if (event.getBlockFace() != BlockFace.EAST && event.getBlockFace() != BlockFace.WEST && event.getBlockFace() != BlockFace.NORTH && event.getBlockFace() != BlockFace.SOUTH && event.getBlockFace() != BlockFace.UP && event.getBlockFace() != BlockFace.DOWN) {
            return;
        }
        BlockFace face = event.getBlockFace().getOppositeFace();
        Block testBlock = this.switchBlock.getRelative(face);
        boolean passed = false;
        while (true) {
            if (testBlock.getTypeId() == 68) {
                Sign s = (Sign)testBlock.getState();
                if (!s.getLine(1).equalsIgnoreCase("[X]")) continue;
                int itemID = -1;
                if (!s.getLine(0).trim().isEmpty()) {
                    try {
                        itemID = Integer.parseInt(s.getLine(0).trim());
                    }
                    catch (NumberFormatException ignored) {
                        // empty catch block
                    }
                }
                if (!s.getLine(2).trim().isEmpty() && !this.plugin.isInGroup(event.getPlayer().getName(), s.getLine(2).trim())) {
                    player.printError("mech.group");
                    return;
                }
                if (itemID == -1) {
                    this.toggleSwitches(testBlock, event.getBlockFace().getOppositeFace());
                    break;
                }
                if (event.getPlayer().getItemInHand() != null || itemID == 0) {
                    if (itemID == 0 && event.getPlayer().getItemInHand() == null || event.getPlayer().getItemInHand().getTypeId() == itemID) {
                        this.toggleSwitches(testBlock, event.getBlockFace().getOppositeFace());
                        break;
                    }
                    player.printError("mech.hiddenswitch.key");
                    break;
                }
                player.printError("mech.hiddenswitch.key");
                break;
            }
            if (!this.plugin.getLocalConfiguration().hiddenSwitchSettings.anyside || face == event.getBlockFace().getOppositeFace() && passed) break;
            passed = true;
            switch (face) {
                case WEST: {
                    face = BlockFace.NORTH;
                    break;
                }
                case NORTH: {
                    face = BlockFace.EAST;
                    break;
                }
                case EAST: {
                    face = BlockFace.SOUTH;
                    break;
                }
                case SOUTH: {
                    face = BlockFace.UP;
                    break;
                }
                case UP: {
                    face = BlockFace.DOWN;
                    break;
                }
                case DOWN: {
                    face = BlockFace.WEST;
                    break;
                }
            }
            testBlock = this.switchBlock.getRelative(face);
        }
        if (!event.getPlayer().isSneaking()) {
            event.setCancelled(true);
        }
    }

    private void toggleSwitches(Block sign, BlockFace direction) {
        BlockFace[] checkFaces = new BlockFace[4];
        checkFaces[0] = BlockFace.UP;
        checkFaces[1] = BlockFace.DOWN;
        switch (direction) {
            case WEST: 
            case EAST: {
                checkFaces[2] = BlockFace.NORTH;
                checkFaces[3] = BlockFace.SOUTH;
                break;
            }
            default: {
                checkFaces[2] = BlockFace.EAST;
                checkFaces[3] = BlockFace.WEST;
            }
        }
        for (BlockFace blockFace : checkFaces) {
            final Block checkBlock = sign.getRelative(blockFace);
            if (checkBlock.getTypeId() == 69) {
                checkBlock.setData((byte)(checkBlock.getData() ^ 8));
                continue;
            }
            if (checkBlock.getTypeId() != 77 && checkBlock.getTypeId() != 143) continue;
            checkBlock.setData((byte)(checkBlock.getData() | 8));
            Runnable turnOff = new Runnable(){

                public void run() {
                    checkBlock.setData((byte)(checkBlock.getData() & 0xFFFFFFF7));
                }
            };
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, turnOff, 20L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<HiddenSwitch> {
        final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public HiddenSwitch detect(BlockWorldVector pos, LocalPlayer player, ChangedSign sign) throws InvalidMechanismException {
            if (sign.getLine(1).equalsIgnoreCase("[X]")) {
                player.checkPermission("craftbook.mech.hiddenswitch");
                return new HiddenSwitch(BukkitUtil.toBlock((BlockWorldVector)pos), this.plugin);
            }
            return null;
        }

        private boolean isValidWallSign(World world, Vector v) {
            Block b = world.getBlockAt(v.getBlockX(), v.getBlockY(), v.getBlockZ());
            if (b == null || b.getTypeId() != 68) {
                return false;
            }
            if (!(b.getState() instanceof Sign)) {
                return false;
            }
            Sign s = (Sign)b.getState();
            return s.getLine(1).equalsIgnoreCase("[X]");
        }

        public HiddenSwitch detect(BlockWorldVector pos) throws InvalidMechanismException {
            World wrd = BukkitUtil.toWorld((WorldVector)pos);
            if (this.isValidWallSign(wrd, pos.add(1, 0, 0)) || this.isValidWallSign(wrd, pos.add(-1, 0, 0)) || this.isValidWallSign(wrd, pos.add(0, 0, 1)) || this.isValidWallSign(wrd, pos.add(0, 0, -1))) {
                return new HiddenSwitch(BukkitUtil.toBlock((BlockWorldVector)pos), this.plugin);
            }
            return null;
        }
    }
}

