/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import java.util.HashMap;
import org.bukkit.Art;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PaintingSwitch
implements Listener {
    MechanismsPlugin plugin;
    HashMap<Painting, String> paintings = new HashMap();
    HashMap<String, Painting> players = new HashMap();

    public PaintingSwitch(MechanismsPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean isBeingEdited(Painting paint) {
        String player = this.paintings.get(paint);
        if (player != null && this.players.get(player) != null) {
            Player p = this.plugin.getServer().getPlayer(player);
            return p != null && !p.isDead();
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (event.getRightClicked() instanceof Painting) {
            LocalPlayer player = this.plugin.wrap(event.getPlayer());
            if (!this.plugin.getLocalConfiguration().paintingSettings.enabled) {
                return;
            }
            Painting paint = (Painting)event.getRightClicked();
            if (!this.plugin.canUseInArea(paint.getLocation(), event.getPlayer())) {
                return;
            }
            if (player.hasPermission("craftbook.mech.paintingswitch.use")) {
                if (!this.isBeingEdited(paint)) {
                    this.paintings.put(paint, player.getName());
                    this.players.put(player.getName(), paint);
                    player.print("mech.painting.editing");
                } else if (this.paintings.get(paint).equalsIgnoreCase(player.getName())) {
                    this.paintings.remove(paint);
                    this.players.remove(player.getName());
                    player.print("mech.painting.stop");
                } else if (this.isBeingEdited(paint)) {
                    player.print(player.translate("mech.painting.used") + " " + this.paintings.get(paint));
                } else {
                    return;
                }
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHeldItemChange(PlayerItemHeldEvent event) {
        boolean isForwards;
        if (!this.plugin.getLocalConfiguration().paintingSettings.enabled) {
            return;
        }
        LocalPlayer player = this.plugin.wrap(event.getPlayer());
        if (!player.hasPermission("craftbook.mech.paintingswitch.use")) {
            return;
        }
        if (this.players.get(player.getName()) == null || this.players.get(player.getName()).isDead() || !this.players.get(player.getName()).isValid()) {
            return;
        }
        if (event.getNewSlot() > event.getPreviousSlot()) {
            isForwards = true;
        } else if (event.getNewSlot() < event.getPreviousSlot()) {
            isForwards = false;
        } else {
            return;
        }
        if (event.getPreviousSlot() == 0 && event.getNewSlot() == 8) {
            isForwards = false;
        } else if (event.getPreviousSlot() == 8 && event.getNewSlot() == 0) {
            isForwards = true;
        }
        Art[] art = (Art[])Art.values().clone();
        Painting paint = this.players.get(player.getName());
        int newID = paint.getArt().getId() + (isForwards ? 1 : -1);
        if (newID < 0) {
            newID = art.length - 1;
        } else if (newID > art.length - 1) {
            newID = 0;
        }
        while (!paint.setArt(art[newID])) {
            if (newID > 0 && !isForwards) {
                --newID;
                continue;
            }
            if (newID >= art.length - 1 || !isForwards) break;
            ++newID;
        }
        this.paintings.put(paint, player.getName());
        this.players.put(player.getName(), paint);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Painting p = this.players.remove(event.getPlayer().getName());
        if (p != null) {
            this.paintings.remove(p);
        }
    }
}

