/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.material.Lever;
import org.bukkit.plugin.Plugin;

public class Payment
extends AbstractMechanic {
    final MechanismsPlugin plugin;
    protected final BlockWorldVector pt;

    public Payment(BlockWorldVector pt, MechanismsPlugin plugin) {
        this.pt = pt;
        this.plugin = plugin;
    }

    public void onRightClick(PlayerInteractEvent event) {
        BlockState state;
        LocalPlayer player = this.plugin.wrap(event.getPlayer());
        if (!player.hasPermission("craftbook.mech.pay.use")) {
            player.printError("mech.use-permission");
            return;
        }
        Block block = BukkitUtil.toWorld((WorldVector)this.pt).getBlockAt(BukkitUtil.toLocation((WorldVector)this.pt));
        Sign sign = null;
        if (block.getTypeId() == 68 && (state = block.getState()) instanceof Sign) {
            sign = (Sign)state;
        }
        if (sign == null) {
            return;
        }
        double money = Double.parseDouble(sign.getLine(2));
        String reciever = sign.getLine(3);
        if (MechanismsPlugin.economy.withdrawPlayer(event.getPlayer().getName(), money).transactionSuccess()) {
            if (MechanismsPlugin.economy.depositPlayer(reciever, money).transactionSuccess()) {
                Block back = SignUtil.getBackBlock((Block)sign.getBlock());
                BlockFace bface = sign.getBlock().getFace(back);
                Block redstoneItem = back.getRelative(bface);
                if (Payment.setState(sign.getBlock(), true)) {
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new TurnOff(redstoneItem), 20L);
                }
            } else {
                MechanismsPlugin.economy.depositPlayer(event.getPlayer().getName(), money);
            }
        }
        event.setCancelled(true);
    }

    public static boolean setState(Block block, boolean state) {
        if (block.getTypeId() != 69) {
            return false;
        }
        byte data = block.getData();
        Block sourceBlock = block.getRelative(((Lever)block.getState().getData()).getAttachedFace());
        int newData = !state ? data & 7 : data | 8;
        if (newData != data) {
            block.setData((byte)newData, true);
            int oldS = state ? 0 : 1;
            int newS = state ? 1 : 0;
            BlockRedstoneEvent event = new BlockRedstoneEvent(sourceBlock, oldS, newS);
            Bukkit.getPluginManager().callEvent((Event)event);
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Payment> {
        protected final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public Payment detect(BlockWorldVector pt) {
            Sign sign;
            BlockState state;
            Block block = BukkitUtil.toWorld((WorldVector)pt).getBlockAt(BukkitUtil.toLocation((WorldVector)pt));
            if (block.getTypeId() == 68 && (state = block.getState()) instanceof Sign && (sign = (Sign)state).getLine(1).equalsIgnoreCase("[Pay]")) {
                return new Payment(pt, this.plugin);
            }
            return null;
        }

        public Payment detect(BlockWorldVector pt, LocalPlayer player, ChangedSign sign) throws InvalidMechanismException, ProcessedMechanismException {
            if (sign.getLine(1).equalsIgnoreCase("[Pay]")) {
                if (!player.hasPermission("craftbook.mech.pay")) {
                    throw new InsufficientPermissionsException();
                }
            } else {
                return null;
            }
            sign.setLine(1, "[Pay]");
            player.print("mech.pay.create");
            throw new ProcessedMechanismException();
        }
    }

    private static class TurnOff
    implements Runnable {
        final Block block;

        public TurnOff(Block block) {
            this.block = block;
        }

        public void run() {
            Payment.setState(this.block, false);
        }
    }
}

