/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import java.util.HashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class Snow
implements Listener {
    final MechanismsPlugin plugin;
    private HashMap<Location, Integer> tasks = new HashMap();

    public Snow(MechanismsPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSnowballHit(ProjectileHitEvent event) {
        if (!this.plugin.getLocalConfiguration().snowSettings.placeSnow) {
            return;
        }
        if (event.getEntity() instanceof Snowball) {
            LocalPlayer player;
            if (event.getEntity().getShooter() != null && event.getEntity().getShooter() instanceof Player && !(player = this.plugin.wrap((Player)event.getEntity().getShooter())).hasPermission("craftbook.mech.snow.place")) {
                return;
            }
            Block block = event.getEntity().getLocation().getBlock();
            this.incrementData(block);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this.plugin.getLocalConfiguration().snowSettings.trample) {
            return;
        }
        if (!event.getFrom().getWorld().getName().equalsIgnoreCase(event.getTo().getWorld().getName())) {
            return;
        }
        LocalPlayer player = this.plugin.wrap(event.getPlayer());
        if (!player.hasPermission("craftbook.mech.snow.trample")) {
            return;
        }
        if (this.plugin.getLocalConfiguration().snowSettings.jumpTrample && event.getPlayer().getVelocity().getY() >= 0.0) {
            return;
        }
        if (BaseBukkitPlugin.random.nextInt(30) == 0) {
            Block b = event.getPlayer().getWorld().getBlockAt(event.getPlayer().getLocation());
            if (b.getTypeId() == 78) {
                if (!this.plugin.canBuildInArea(event.getPlayer().getLocation(), event.getPlayer())) {
                    return;
                }
                this.lowerData(b);
            }
            if ((b = event.getPlayer().getWorld().getBlockAt(event.getPlayer().getLocation().subtract(0.0, 1.0, 0.0))).getTypeId() == 78) {
                if (!this.plugin.canBuildInArea(event.getPlayer().getLocation(), event.getPlayer())) {
                    return;
                }
                this.lowerData(b);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent event) {
        if (!this.plugin.getLocalConfiguration().snowSettings.enable) {
            return;
        }
        if (event.getNewState().getTypeId() == 78) {
            Block block = event.getBlock();
            this.pile(block);
        }
    }

    public void pile(Block block) {
        if (block.getTypeId() != 80 && block.getTypeId() != 78) {
            Location blockLoc = block.getLocation().subtract(0.0, 1.0, 0.0);
            if (block.getWorld().getBlockAt(blockLoc).getTypeId() == 80 && !this.plugin.getLocalConfiguration().snowSettings.piling || block.getWorld().getBlockAt(blockLoc).getTypeId() == 78) {
                return;
            }
            this.schedule(block.getLocation());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPhysics(BlockPhysicsEvent event) {
        if (!this.plugin.getLocalConfiguration().snowSettings.enable) {
            return;
        }
        if (event.getBlock().getTypeId() == 78) {
            Block block = event.getBlock();
            if (this.plugin.getLocalConfiguration().snowSettings.realistic) {
                this.disperse(event.getBlock(), true);
            }
            if (event.getBlock().getWorld().hasStorm()) {
                this.pile(block);
            }
        }
    }

    public void schedule(Location loc) {
        if (this.tasks.containsKey(loc)) {
            return;
        }
        long delay = BaseBukkitPlugin.random.nextInt(60) + 40;
        int taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new MakeSnow(loc), delay * 20L, delay * 20L);
        if (taskID == -1) {
            this.plugin.getLogger().log(Level.SEVERE, "[CraftBookMechanisms] Snow Mechanic failed to schedule!");
        } else {
            this.tasks.put(loc, taskID);
        }
    }

    public void lowerData(Block block) {
        byte newData;
        if (block.getRelative(0, -1, 0).getTypeId() == 8 || block.getRelative(0, -1, 0).getTypeId() == 9) {
            block.getRelative(0, -1, 0).setTypeId(79, false);
        }
        if ((newData = (byte)(block.getData() - 1)) < 1) {
            block.setTypeId(0, false);
            newData = 0;
        }
        if (block.getTypeId() == 80) {
            block.setTypeId(78, false);
            newData = 7;
        }
        if (newData > 7) {
            newData = 0;
        }
        this.setBlockDataWithNotify(block, newData);
    }

    public boolean disperse(Block block, boolean remove) {
        if (block.getRelative(0, -1, 0).getTypeId() == 8 || block.getRelative(0, -1, 0).getTypeId() == 9) {
            block.getRelative(0, -1, 0).setTypeId(79, false);
        }
        if (this.isValidBlock(block.getRelative(0, -1, 0).getTypeId()) && block.getRelative(0, -1, 0).getData() < 7 && (block.getRelative(0, -1, 0).getData() < block.getData() || block.getRelative(0, -1, 0).getTypeId() != 78)) {
            this.incrementData(block.getRelative(0, -1, 0));
            if (remove) {
                this.lowerData(block);
            }
            return true;
        }
        if (this.isValidBlock(block.getRelative(1, 0, 0).getTypeId()) && block.getRelative(1, 0, 0).getData() < 7 && (block.getRelative(1, 0, 0).getData() < block.getData() || block.getRelative(1, 0, 0).getTypeId() != 78)) {
            this.incrementData(block.getRelative(1, 0, 0));
            if (remove) {
                this.lowerData(block);
            }
            return true;
        }
        if (this.isValidBlock(block.getRelative(-1, 0, 0).getTypeId()) && block.getRelative(-1, 0, 0).getData() < 7 && (block.getRelative(-1, 0, 0).getData() < block.getData() || block.getRelative(-1, 0, 0).getTypeId() != 78)) {
            this.incrementData(block.getRelative(-1, 0, 0));
            if (remove) {
                this.lowerData(block);
            }
            return true;
        }
        if (this.isValidBlock(block.getRelative(0, 0, 1).getTypeId()) && block.getRelative(0, 0, 1).getData() < 7 && (block.getRelative(0, 0, 1).getData() < block.getData() || block.getRelative(0, 0, 1).getTypeId() != 78)) {
            this.incrementData(block.getRelative(0, 0, 1));
            if (remove) {
                this.lowerData(block);
            }
            return true;
        }
        if (this.isValidBlock(block.getRelative(0, 0, -1).getTypeId()) && block.getRelative(0, 0, -1).getData() < 7 && (block.getRelative(0, 0, -1).getData() < block.getData() || block.getRelative(0, 0, -1).getTypeId() != 78)) {
            this.incrementData(block.getRelative(0, 0, -1));
            if (remove) {
                this.lowerData(block);
            }
            return true;
        }
        return false;
    }

    public void incrementData(Block block) {
        if (block.getRelative(0, -1, 0).getTypeId() == 8 || block.getRelative(0, -1, 0).getTypeId() == 9) {
            block.getRelative(0, -1, 0).setTypeId(79, false);
        }
        if (!this.isValidBlock(block.getTypeId()) && this.isValidBlock(block.getRelative(0, 1, 0).getTypeId())) {
            this.incrementData(block.getRelative(0, 1, 0));
            return;
        }
        if (!this.isValidBlock(block.getTypeId())) {
            return;
        }
        if (this.canPassThrough(block.getTypeId()) && this.canPassThrough(block.getRelative(0, -1, 0).getTypeId())) {
            this.incrementData(block.getRelative(0, -1, 0));
            return;
        }
        if (this.canPassThrough(block.getTypeId()) && block.getRelative(0, -1, 0).getTypeId() == 78 && block.getRelative(0, -1, 0).getData() < 7) {
            this.incrementData(block.getRelative(0, -1, 0));
            return;
        }
        if (block.getTypeId() == 80 && this.isValidBlock(block.getRelative(0, 1, 0).getTypeId())) {
            this.incrementData(block.getRelative(0, 1, 0));
            return;
        }
        if (this.plugin.getLocalConfiguration().snowSettings.realistic && block.getTypeId() == 78 && this.disperse(block, false)) {
            return;
        }
        byte newData = 0;
        if (block.getTypeId() != 78 && this.canPassThrough(block.getTypeId())) {
            block.setTypeId(78, false);
        } else {
            newData = (byte)(block.getData() + 1);
        }
        if (newData > 7 && this.plugin.getLocalConfiguration().snowSettings.piling) {
            block.setTypeId(80, false);
            newData = 0;
        } else if (newData > 7) {
            newData = (byte)7;
        }
        this.setBlockDataWithNotify(block, newData);
    }

    public void setBlockDataWithNotify(Block block, byte data) {
        block.setTypeIdAndData(block.getTypeId(), data, false);
        for (Player p : block.getWorld().getPlayers()) {
            if (!(p.getLocation().distanceSquared(block.getLocation()) < (double)(this.plugin.getServer().getViewDistance() * 16 * this.plugin.getServer().getViewDistance() * 16))) continue;
            p.sendBlockChange(block.getLocation(), block.getTypeId(), data);
        }
    }

    public boolean canPassThrough(int id) {
        return id == 32 || id == 0 || id == 31 || id == 51;
    }

    public boolean isSnowBlock(int id) {
        return id == 78;
    }

    public boolean isValidBlock(int id) {
        return this.canPassThrough(id) || this.isSnowBlock(id);
    }

    public class MakeSnow
    implements Runnable {
        final Location event;

        public MakeSnow(Location event) {
            this.event = event;
        }

        public void run() {
            if (!Snow.this.tasks.containsKey(this.event)) {
                return;
            }
            if (this.event.getWorld().hasStorm()) {
                if (this.event.getBlock().getData() > 7) {
                    return;
                }
                if (this.event.subtract(0.0, 1.0, 0.0).getBlock().getTypeId() == 0) {
                    return;
                }
                this.event.add(0.0, 1.0, 0.0);
                if (this.event.getBlock().getTypeId() != 78 && this.event.getBlock().getTypeId() != 80) {
                    return;
                }
                Snow.this.incrementData(this.event.getBlock());
            } else {
                Integer taskID = (Integer)Snow.this.tasks.get(this.event);
                if (taskID == null) {
                    return;
                }
                Bukkit.getScheduler().cancelTask(taskID.intValue());
                Snow.this.tasks.remove(this.event);
            }
        }
    }
}

