/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech.area;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.mech.area.CopyManager;
import com.sk89q.craftbook.mech.area.CuboidCopy;
import com.sk89q.craftbook.mech.area.CuboidCopyException;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.data.DataException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.event.player.PlayerInteractEvent;

public class Area
extends AbstractMechanic {
    public final MechanismsPlugin plugin;
    public final BlockWorldVector pt;
    private boolean toggledOn;
    protected boolean saveOnToggle = false;
    private static final Pattern pattern = Pattern.compile("^\\-[A-Za-z0-9_]*?\\-$");

    public void onRightClick(PlayerInteractEvent event) {
        LocalPlayer player = this.plugin.wrap(event.getPlayer());
        if (!player.hasPermission("craftbook.mech.area.use")) {
            player.print("mech.use-permission");
            return;
        }
        Sign sign = null;
        if (BukkitUtil.toBlock((BlockWorldVector)this.pt).getState() instanceof Sign) {
            sign = (Sign)BukkitUtil.toBlock((BlockWorldVector)this.pt).getState();
        }
        if (sign == null) {
            return;
        }
        this.toggle(sign);
        event.setCancelled(true);
    }

    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!this.plugin.getLocalConfiguration().areaSettings.enableRedstone) {
            return;
        }
        Sign sign = null;
        if (BukkitUtil.toBlock((BlockWorldVector)this.pt).getState() instanceof Sign) {
            sign = (Sign)BukkitUtil.toBlock((BlockWorldVector)this.pt).getState();
        }
        if (sign == null) {
            return;
        }
        this.toggle(sign);
    }

    private Area(BlockWorldVector pt, MechanismsPlugin plugin, boolean save) throws InvalidMechanismException {
        this.plugin = plugin;
        this.pt = pt;
        this.saveOnToggle = save;
    }

    public boolean isToggledOn() {
        return this.toggledOn;
    }

    private void toggle(Sign sign) {
        if (!this.checkSign(sign)) {
            return;
        }
        try {
            World world = sign.getWorld();
            String namespace = sign.getLine(0);
            String id = sign.getLine(2).replace("-", "");
            String inactiveID = sign.getLine(3).replace("-", "");
            CuboidCopy copy = CopyManager.getInstance().load(world, namespace, id, this.plugin);
            if (this.isToggledOn()) {
                if (this.saveOnToggle) {
                    copy.copy();
                    CopyManager.getInstance().save(world, namespace, id, copy, this.plugin);
                }
                if (!inactiveID.isEmpty() && !inactiveID.equals("--")) {
                    copy = CopyManager.getInstance().load(world, namespace, inactiveID, this.plugin);
                    copy.paste();
                } else {
                    copy.clear();
                }
                this.setToggledState(sign, false);
            } else {
                if (this.saveOnToggle && !inactiveID.isEmpty() && !inactiveID.equals("--")) {
                    copy.copy();
                    CopyManager.getInstance().save(world, namespace, inactiveID, copy, this.plugin);
                }
                copy.paste();
                this.setToggledState(sign, true);
            }
        }
        catch (CuboidCopyException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to toggle Area: " + e.getMessage());
        }
        catch (DataException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to toggle Area: " + e.getMessage());
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to toggle Area: " + e.getMessage());
        }
    }

    private boolean checkSign(Sign sign) {
        String namespace = sign.getLine(0);
        String id = sign.getLine(2);
        if (id == null || id.isEmpty() || id.length() < 1) {
            return false;
        }
        if (namespace == null || namespace.isEmpty() || namespace.length() < 1) {
            return false;
        }
        this.checkToggleState(sign);
        return true;
    }

    private void checkToggleState(Sign sign) {
        String line3 = sign.getLine(2);
        String line4 = sign.getLine(3);
        this.toggledOn = pattern.matcher(line3).matches() || !line4.equals("--") && !pattern.matcher(line4).matches();
    }

    private void setToggledState(Sign sign, boolean state) {
        int toToggleOn = state ? 2 : 3;
        int toToggleOff = state ? 3 : 2;
        sign.setLine(toToggleOff, sign.getLine(toToggleOff).replace("-", ""));
        sign.setLine(toToggleOn, "-" + sign.getLine(toToggleOn) + "-");
        sign.update();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Area> {
        private final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public Area detect(BlockWorldVector pt, LocalPlayer player, ChangedSign sign) throws InvalidMechanismException, ProcessedMechanismException {
            if (!this.plugin.getLocalConfiguration().areaSettings.enable) {
                return null;
            }
            String[] lines = sign.getLines();
            if (lines[1].equalsIgnoreCase("[Area]") || lines[1].equalsIgnoreCase("[SaveArea]")) {
                if (sign.getLine(0).trim().isEmpty()) {
                    sign.setLine(0, "~" + player.getName());
                }
                if (lines[1].equalsIgnoreCase("[Area]")) {
                    player.checkPermission("craftbook.mech.area.sign.area");
                    sign.setLine(1, "[Area]");
                } else if (lines[1].equalsIgnoreCase("[SaveArea]")) {
                    player.checkPermission("craftbook.mech.area.sign.savearea");
                    sign.setLine(1, "[SaveArea]");
                }
            } else {
                return null;
            }
            sign.update(false);
            this.isValidArea(sign);
            player.print("Toggle area created.");
            throw new ProcessedMechanismException();
        }

        public Area detect(BlockWorldVector pt) throws InvalidMechanismException {
            ChangedSign sign;
            BlockState state;
            if (!this.plugin.getLocalConfiguration().areaSettings.enableRedstone) {
                return null;
            }
            Block block = BukkitUtil.toWorld((WorldVector)pt).getBlockAt(BukkitUtil.toLocation((WorldVector)pt));
            if (SignUtil.isSign((int)block.getTypeId()) && (state = block.getState()) instanceof Sign && ((sign = BukkitUtil.toChangedSign((Sign)((Sign)state))).getLine(1).equalsIgnoreCase("[Area]") || sign.getLine(1).equalsIgnoreCase("[SaveArea]"))) {
                sign.update(false);
                this.isValidArea(sign);
                boolean save = sign.getLine(1).equalsIgnoreCase("[SaveArea]");
                return new Area(pt, this.plugin, save);
            }
            return null;
        }

        private void isValidArea(ChangedSign sign) throws InvalidMechanismException {
            String namespace = sign.getLine(0).trim();
            String areaOn = sign.getLine(2).trim();
            String areaOff = sign.getLine(3).trim();
            if (CopyManager.isExistingArea(this.plugin, namespace, areaOn)) {
                if (areaOff == null || areaOff.isEmpty() || areaOff.equals("--")) {
                    return;
                }
                if (CopyManager.isExistingArea(this.plugin, namespace, areaOff)) {
                    return;
                }
            }
            throw new InvalidMechanismException("The area or namespace does not exist.");
        }
    }
}

