/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech.area;

import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.mech.area.CuboidCopy;
import com.sk89q.craftbook.mech.area.CuboidCopyException;
import com.sk89q.craftbook.mech.area.MissingCuboidCopyException;
import com.sk89q.craftbook.util.HistoryHashMap;
import com.sk89q.worldedit.data.DataException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.bukkit.World;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyManager {
    private static final CopyManager INSTANCE = new CopyManager();
    private static final Pattern NAME_PATTERN = Pattern.compile("^[a-z0-9_]+$", 2);
    private final HashMap<String, HistoryHashMap<String, CuboidCopy>> cache = new HashMap();
    private final HashMap<String, HistoryHashMap<String, Long>> missing = new HashMap();

    public static CopyManager getInstance() {
        return INSTANCE;
    }

    public static boolean isValidName(String name) {
        return !name.isEmpty() && name.length() <= 13 && NAME_PATTERN.matcher(name).matches();
    }

    public static boolean isValidNamespace(String name) {
        return !name.isEmpty() && name.length() <= 14 && NAME_PATTERN.matcher(name).matches();
    }

    public static boolean isExistingArea(MechanismsPlugin plugin, String namespace, String area) {
        area = area.replace("-", "") + CopyManager.getFileSuffix(plugin);
        File file = new File(plugin.getDataFolder(), "areas/" + namespace);
        return new File(file, area).exists();
    }

    public CuboidCopy load(World world, String namespace, String id, MechanismsPlugin plugin) throws IOException, CuboidCopyException {
        long lastCheck;
        id = id.toLowerCase();
        String cacheKey = namespace + "/" + id;
        HistoryHashMap<String, Long> missing = this.getMissing(world.getUID().toString());
        if (missing.containsKey((Object)cacheKey) && (lastCheck = ((Long)missing.get((Object)cacheKey)).longValue()) > System.currentTimeMillis()) {
            throw new MissingCuboidCopyException(id);
        }
        HistoryHashMap<String, CuboidCopy> cache = this.getCache(world.getUID().toString());
        CuboidCopy copy = (CuboidCopy)cache.get((Object)cacheKey);
        if (copy == null) {
            File folder = new File(new File(plugin.getDataFolder(), "areas"), namespace);
            copy = CuboidCopy.load(new File(folder, id + CopyManager.getFileSuffix(plugin)), world);
            missing.remove((Object)cacheKey);
            cache.put((Object)cacheKey, (Object)copy);
            return copy;
        }
        return copy;
    }

    public void save(World world, String namespace, String id, CuboidCopy copyFlat, MechanismsPlugin plugin) throws IOException, DataException {
        HistoryHashMap<String, CuboidCopy> cache = this.getCache(world.getUID().toString());
        File folder = new File(new File(plugin.getDataFolder(), "areas"), namespace);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        id = id.toLowerCase();
        String cacheKey = namespace + "/" + id;
        copyFlat.save(new File(folder, id + CopyManager.getFileSuffix(plugin)));
        this.missing.remove(cacheKey);
        cache.put((Object)cacheKey, (Object)copyFlat);
    }

    public int meetsQuota(World world, String namespace, String ignore, int quota, MechanismsPlugin plugin) {
        String ignoreFilename = ignore + CopyManager.getFileSuffix(plugin);
        String[] files = new File(new File(plugin.getDataFolder(), "areas"), namespace).list();
        if (files == null) {
            return quota > 0 ? -1 : 0;
        }
        if (ignore == null) {
            return files.length < quota ? -1 : files.length;
        }
        int count = 0;
        for (String f : files) {
            if (f.equals(ignoreFilename)) {
                return -1;
            }
            ++count;
        }
        return count < quota ? -1 : count;
    }

    private HistoryHashMap<String, CuboidCopy> getCache(String world) {
        HistoryHashMap worldCache = this.cache.get(world);
        if (worldCache != null) {
            return worldCache;
        }
        worldCache = new HistoryHashMap(10);
        this.cache.put(world, (HistoryHashMap<String, CuboidCopy>)worldCache);
        return worldCache;
    }

    private HistoryHashMap<String, Long> getMissing(String world) {
        HistoryHashMap worldCache = this.missing.get(world);
        if (worldCache != null) {
            return worldCache;
        }
        worldCache = new HistoryHashMap(10);
        this.missing.put(world, (HistoryHashMap<String, Long>)worldCache);
        return worldCache;
    }

    private static String getFileSuffix(MechanismsPlugin plugin) {
        return plugin.getLocalConfiguration().areaSettings.useSchematics ? ".schematic" : ".cbcopy";
    }
}

